/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import com.vaadin.ui.TreeTable;
import org.jsimpledb.vaadin.TypeContainer;

public class TypeTable
extends TreeTable {
    public TypeTable(TypeContainer container) {
        super(null, (Container)container);
        this.setSelectable(true);
        this.setImmediate(true);
        this.setSizeFull();
        this.setHierarchyColumn("name");
        this.setAnimationsEnabled(true);
        this.addColumn("name", "Type", 140, Table.Align.LEFT);
        this.addColumn("storageId", "SID", 40, Table.Align.CENTER);
        this.addColumn("type", "Java Type", 250, Table.Align.CENTER);
        this.setColumnExpandRatio("name", 1.0f);
        this.setVisibleColumns(new Object[]{"name", "storageId", "type"});
        this.setColumnCollapsingAllowed(true);
        this.setColumnCollapsed("storageId", true);
        this.setColumnCollapsed("type", true);
    }

    protected void addColumn(String property, String name, int width, Table.Align alignment) {
        this.setColumnHeader(property, name);
        this.setColumnWidth(property, width);
        if (alignment != null) {
            this.setColumnAlignment(property, alignment);
        }
    }

    public TypeContainer getContainer() {
        return (TypeContainer)this.getContainerDataSource();
    }

    public void attach() {
        super.attach();
        this.getContainer().connect();
        for (Class type : this.getContainer().rootItemIds()) {
            this.setCollapsed(type, false);
        }
    }

    public void detach() {
        this.getContainer().disconnect();
        super.detach();
    }
}

