/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;

public abstract class AbstractKVStore
implements KVStore {
    protected AbstractKVStore() {
    }

    @Override
    public byte[] get(byte[] key) {
        KVPair pair = this.getAtLeast(key, ByteUtil.getNextKey((byte[])key));
        if (pair == null) {
            return null;
        }
        assert (Arrays.equals(pair.getKey(), key));
        return pair.getValue();
    }

    @Override
    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        if (minKey != null && maxKey != null && ByteUtil.compare((byte[])minKey, (byte[])maxKey) >= 0) {
            return null;
        }
        try (CloseableIterator<KVPair> i = this.getRange(minKey, maxKey, false);){
            KVPair kVPair = i.hasNext() ? (KVPair)i.next() : null;
            return kVPair;
        }
    }

    @Override
    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        if (minKey != null && maxKey != null && ByteUtil.compare((byte[])minKey, (byte[])maxKey) >= 0) {
            return null;
        }
        try (CloseableIterator<KVPair> i = this.getRange(minKey, maxKey, true);){
            KVPair kVPair = i.hasNext() ? (KVPair)i.next() : null;
            return kVPair;
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(byte[] key) {
        this.removeRange(key, ByteUtil.getNextKey((byte[])key));
    }

    @Override
    public void removeRange(byte[] minKey, byte[] maxKey) {
        try (CloseableIterator<KVPair> i = this.getRange(minKey, maxKey, false);){
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }
    }

    @Override
    public byte[] encodeCounter(long value) {
        ByteWriter writer = new ByteWriter(8);
        ByteUtil.writeLong((ByteWriter)writer, (long)value);
        return writer.getBytes();
    }

    @Override
    public long decodeCounter(byte[] value) {
        Preconditions.checkArgument((value.length == 8 ? 1 : 0) != 0, (Object)"invalid encoded counter value length != 8");
        return ByteUtil.readLong((ByteReader)new ByteReader(value));
    }

    @Override
    public void adjustCounter(byte[] key, long amount) {
        long oldValue;
        if (key == null) {
            throw new NullPointerException("null key");
        }
        byte[] previous = this.get(key);
        if (previous == null) {
            return;
        }
        try {
            oldValue = this.decodeCounter(previous);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        this.put(key, this.encodeCounter(oldValue + amount));
    }
}

