/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.mvcc.AtomicKVDatabase;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.util.ImplementationsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KVImplementation {
    public static final String XML_DESCRIPTOR_RESOURCE = "META-INF/jsimpledb/kv-implementations.xml";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract String[][] getCommandLineOptions();

    public String getUsageText() {
        return null;
    }

    public abstract Object parseCommandLineOptions(ArrayDeque<String> var1);

    protected String parseCommandLineOption(ArrayDeque<String> options, String flag) {
        String arg = null;
        Iterator<String> i = options.iterator();
        while (i.hasNext()) {
            String option = i.next();
            if (!option.equals(flag)) continue;
            i.remove();
            if (!i.hasNext()) {
                throw new IllegalArgumentException("`" + flag + "' missing required argument");
            }
            arg = i.next();
            i.remove();
        }
        return arg;
    }

    protected boolean parseCommandLineFlag(ArrayDeque<String> options, String flag) {
        boolean result = false;
        Iterator<String> i = options.iterator();
        while (i.hasNext()) {
            String option = i.next();
            if (!option.equals(flag)) continue;
            result = true;
            i.remove();
        }
        return result;
    }

    public abstract KVDatabase createKVDatabase(Object var1, KVDatabase var2, AtomicKVStore var3);

    public AtomicKVStore createAtomicKVStore(Object configuration) {
        return new AtomicKVDatabase(this.createKVDatabase(configuration, null, null));
    }

    public boolean requiresAtomicKVStore(Object configuration) {
        return false;
    }

    public boolean requiresKVDatabase(Object configuration) {
        return false;
    }

    public abstract String getDescription(Object var1);

    public static KVImplementation[] getImplementations() {
        List kvs = new ImplementationsReader("kv").findImplementations(KVImplementation.class, XML_DESCRIPTOR_RESOURCE);
        return kvs.toArray(new KVImplementation[kvs.size()]);
    }
}

