/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.jsimpledb.util.ByteUtil;

public class KVPair
implements Cloneable {
    private byte[] key;
    private byte[] value;

    public KVPair(byte[] key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.key = key;
        this.value = value;
    }

    public KVPair(Map.Entry<byte[], byte[]> entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"null entry");
        this.key = entry.getKey();
        this.value = entry.getValue();
        Preconditions.checkArgument((this.key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((this.value != null ? 1 : 0) != 0, (Object)"null value");
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public KVPair clone() {
        KVPair clone;
        try {
            clone = (KVPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.key = (byte[])clone.key.clone();
        clone.value = (byte[])clone.value.clone();
        return clone;
    }

    public String toString() {
        return "{" + ByteUtil.toString((byte[])this.key) + "," + ByteUtil.toString((byte[])this.value) + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KVPair that = (KVPair)obj;
        return Arrays.equals(this.key, that.key) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.value);
    }
}

