/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.CloseableIterator;

public interface KVStore {
    public byte[] get(byte[] var1);

    public KVPair getAtLeast(byte[] var1, byte[] var2);

    public KVPair getAtMost(byte[] var1, byte[] var2);

    public CloseableIterator<KVPair> getRange(byte[] var1, byte[] var2, boolean var3);

    default public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey) {
        return this.getRange(minKey, maxKey, false);
    }

    default public CloseableIterator<KVPair> getRange(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        return this.getRange(range.getMin(), range.getMax(), false);
    }

    public void put(byte[] var1, byte[] var2);

    public void remove(byte[] var1);

    public void removeRange(byte[] var1, byte[] var2);

    default public void removeRange(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        this.removeRange(range.getMin(), range.getMax());
    }

    public byte[] encodeCounter(long var1);

    public long decodeCounter(byte[] var1);

    public void adjustCounter(byte[] var1, long var2);
}

