/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.util.ByteUtil;

public final class KeyFilterUtil {
    private KeyFilterUtil() {
    }

    public static KeyFilter union(KeyFilter ... keyFilters) {
        Preconditions.checkArgument((keyFilters != null ? 1 : 0) != 0, (Object)"null keyFilters");
        switch (keyFilters.length) {
            case 0: {
                throw new IllegalArgumentException("empty keyFilters");
            }
            case 1: {
                Preconditions.checkArgument((keyFilters[0] != null ? 1 : 0) != 0, (Object)"null keyFilter");
                return keyFilters[0];
            }
        }
        boolean allKeyRanges = true;
        for (KeyFilter keyFilter : keyFilters) {
            if (keyFilter instanceof KeyRanges) continue;
            allKeyRanges = false;
            break;
        }
        if (allKeyRanges) {
            KeyRanges union = KeyRanges.empty();
            for (KeyFilter keyFilter : keyFilters) {
                union.add((KeyRanges)keyFilter);
            }
            return union;
        }
        return new UnionKeyFilter(keyFilters);
    }

    public static KeyFilter intersection(KeyFilter ... keyFilters) {
        Preconditions.checkArgument((keyFilters != null ? 1 : 0) != 0, (Object)"null keyFilters");
        switch (keyFilters.length) {
            case 0: {
                throw new IllegalArgumentException("empty keyFilters");
            }
            case 1: {
                Preconditions.checkArgument((keyFilters[0] != null ? 1 : 0) != 0, (Object)"null keyFilter");
                return keyFilters[0];
            }
        }
        boolean allKeyRanges = true;
        for (KeyFilter keyFilter : keyFilters) {
            if (keyFilter instanceof KeyRanges) continue;
            allKeyRanges = false;
            break;
        }
        if (allKeyRanges) {
            KeyRanges intersection = KeyRanges.full();
            for (KeyFilter keyFilter : keyFilters) {
                intersection.intersect((KeyRanges)keyFilter);
            }
            return intersection;
        }
        return new IntersectionKeyFilter(keyFilters);
    }

    public static boolean isEmpty(KeyFilter keyFilter) {
        Preconditions.checkArgument((keyFilter != null ? 1 : 0) != 0, (Object)"null keyFilter");
        return keyFilter.seekHigher(ByteUtil.EMPTY) == null;
    }

    private static byte[] seek(KeyFilter[] keyFilters, byte[] key, boolean seekHigher, boolean preferHigher) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        assert (keyFilters.length > 0);
        boolean preferNull = seekHigher == preferHigher;
        byte[] best = null;
        for (int i = 0; i < keyFilters.length; ++i) {
            byte[] next;
            KeyFilter keyFilter = keyFilters[i];
            byte[] byArray = next = seekHigher ? keyFilter.seekHigher(key) : keyFilter.seekLower(key);
            if (i == 0) {
                best = next;
            }
            if (next == null) {
                if (!preferNull) continue;
                return null;
            }
            assert (next.length != 0 || key.length == 0);
            if (i > 0 && best != null) {
                int diff;
                int n = diff = !seekHigher && next.length == 0 ? 1 : ByteUtil.compare((byte[])next, (byte[])best);
                if (preferHigher ? diff < 0 : diff > 0) {
                    continue;
                }
            } else assert (i == 0 || !preferNull);
            best = next;
        }
        return best;
    }

    private static class IntersectionKeyFilter
    implements KeyFilter {
        private final KeyFilter[] keyFilters;

        IntersectionKeyFilter(KeyFilter[] keyFilters) {
            assert (keyFilters.length >= 2);
            ArrayList<KeyFilter> list = new ArrayList<KeyFilter>();
            for (KeyFilter keyFilter : keyFilters) {
                if (keyFilter instanceof IntersectionKeyFilter) {
                    list.addAll(Arrays.asList(((IntersectionKeyFilter)keyFilter).keyFilters));
                    continue;
                }
                list.add(keyFilter);
            }
            this.keyFilters = list.toArray(new KeyFilter[list.size()]);
        }

        @Override
        public boolean contains(byte[] key) {
            for (KeyFilter keyFilter : this.keyFilters) {
                if (keyFilter.contains(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public byte[] seekHigher(byte[] key) {
            return KeyFilterUtil.seek(this.keyFilters, key, true, true);
        }

        @Override
        public byte[] seekLower(byte[] key) {
            return KeyFilterUtil.seek(this.keyFilters, key, false, false);
        }
    }

    private static class UnionKeyFilter
    implements KeyFilter {
        private final KeyFilter[] keyFilters;

        UnionKeyFilter(KeyFilter[] keyFilters) {
            assert (keyFilters.length >= 2);
            ArrayList<KeyFilter> list = new ArrayList<KeyFilter>();
            for (KeyFilter keyFilter : keyFilters) {
                if (keyFilter instanceof UnionKeyFilter) {
                    list.addAll(Arrays.asList(((UnionKeyFilter)keyFilter).keyFilters));
                    continue;
                }
                list.add(keyFilter);
            }
            this.keyFilters = list.toArray(new KeyFilter[list.size()]);
        }

        @Override
        public boolean contains(byte[] key) {
            for (KeyFilter keyFilter : this.keyFilters) {
                if (!keyFilter.contains(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] seekHigher(byte[] key) {
            return KeyFilterUtil.seek(this.keyFilters, key, true, false);
        }

        @Override
        public byte[] seekLower(byte[] key) {
            return KeyFilterUtil.seek(this.keyFilters, key, false, true);
        }
    }
}

