/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Comparator;
import org.jsimpledb.util.ByteUtil;

public class KeyRange {
    public static final KeyRange FULL = new KeyRange(ByteUtil.EMPTY, null);
    public static final Comparator<KeyRange> SORT_BY_MIN = Comparator.comparing(KeyRange::getMin, ByteUtil::compare).thenComparing(KeyRange::getMax, KeyRange::compare);
    public static final Comparator<KeyRange> SORT_BY_MAX = Comparator.comparing(KeyRange::getMax, KeyRange::compare).thenComparing(KeyRange::getMin, ByteUtil::compare);
    protected final byte[] min;
    protected final byte[] max;

    public KeyRange(byte[] min, byte[] max) {
        Preconditions.checkArgument((min != null ? 1 : 0) != 0, (Object)"null min");
        if (KeyRange.compare(min, max) > 0) {
            throw new IllegalArgumentException("min = " + ByteUtil.toString((byte[])min) + " > max = " + ByteUtil.toString((byte[])max));
        }
        this.min = (byte[])min.clone();
        this.max = max != null ? (byte[])max.clone() : null;
    }

    public KeyRange(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        this.min = (byte[])key.clone();
        this.max = ByteUtil.getNextKey((byte[])this.min);
    }

    public static KeyRange forPrefix(byte[] prefix) {
        byte[] maxKey;
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        if (prefix.length == 0) {
            return FULL;
        }
        try {
            maxKey = ByteUtil.getKeyAfterPrefix((byte[])prefix);
        }
        catch (IllegalArgumentException e) {
            maxKey = null;
        }
        return new KeyRange(prefix, maxKey);
    }

    public byte[] getMin() {
        return (byte[])this.min.clone();
    }

    public byte[] getMax() {
        return this.max == null ? null : (byte[])this.max.clone();
    }

    public boolean overlaps(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        return KeyRange.compare(this.min, range.max) < 0 && KeyRange.compare(range.min, this.max) < 0;
    }

    public boolean contains(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        return KeyRange.compare(this.min, range.min) <= 0 && KeyRange.compare(this.max, range.max) >= 0;
    }

    public boolean contains(byte[] key) {
        return this.compareTo(key) == 0;
    }

    public boolean isFull() {
        return this.min.length == 0 && this.max == null;
    }

    public boolean isSingleKey() {
        int lastIndex = this.min.length;
        if (this.max == null || this.max.length != lastIndex + 1 || this.max[lastIndex] != 0) {
            return false;
        }
        for (int i = 0; i < lastIndex; ++i) {
            if (this.min[i] == this.max[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.max != null && Arrays.equals(this.min, this.max);
    }

    public KeyRange prefixedBy(byte[] prefix) {
        byte[] prefixedMax;
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        byte[] prefixedMin = Bytes.concat((byte[][])new byte[][]{prefix, this.min});
        if (this.max != null) {
            prefixedMax = Bytes.concat((byte[][])new byte[][]{prefix, this.max});
        } else {
            try {
                prefixedMax = ByteUtil.getKeyAfterPrefix((byte[])prefix);
            }
            catch (IllegalArgumentException e) {
                prefixedMax = null;
            }
        }
        return new KeyRange(prefixedMin, prefixedMax);
    }

    public int compareTo(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (KeyRange.compare(this.min, key) > 0) {
            return 1;
        }
        if (KeyRange.compare(this.max, key) <= 0) {
            return -1;
        }
        return 0;
    }

    public static int compare(byte[] key1, byte[] key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        return ByteUtil.compare((byte[])key1, (byte[])key2);
    }

    public static KeyRange empty(byte[] key) {
        return new KeyRange(key, key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KeyRange that = (KeyRange)obj;
        return Arrays.equals(this.min, that.min) && (this.max == null ? that.max == null : Arrays.equals(this.max, that.max));
    }

    public int hashCode() {
        return Arrays.hashCode(this.min) ^ (this.max != null ? Arrays.hashCode(this.max) : 0);
    }

    public String toString() {
        return "[" + ByteUtil.toString((byte[])this.min) + "," + ByteUtil.toString((byte[])this.max) + ")";
    }
}

