/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.kv.util.UnmodifiableKVStore;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.LoggerFactory;

public class AtomicKVDatabase
extends AbstractKVStore
implements AtomicKVStore {
    protected final KVDatabase kvdb;

    public AtomicKVDatabase(KVDatabase kvdb) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0, (Object)"null kvdb");
        this.kvdb = kvdb;
    }

    @Override
    public byte[] get(byte[] key) {
        return this.doInTransaction(kv -> kv.get(key));
    }

    @Override
    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        return this.doInTransaction(kv -> kv.getAtLeast(minKey, maxKey));
    }

    @Override
    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        return this.doInTransaction(kv -> kv.getAtMost(maxKey, minKey));
    }

    public KVPairIterator getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        return new KVPairIterator(this, new KeyRange(minKey != null ? minKey : ByteUtil.EMPTY, maxKey), null, reverse);
    }

    @Override
    public void put(final byte[] key, final byte[] value) {
        this.doInTransaction(new Action<Void>(){

            @Override
            public Void apply(KVStore kv) {
                kv.put(key, value);
                return null;
            }
        });
    }

    @Override
    public void remove(final byte[] key) {
        this.doInTransaction(new Action<Void>(){

            @Override
            public Void apply(KVStore kv) {
                kv.remove(key);
                return null;
            }
        });
    }

    @Override
    public void removeRange(final byte[] minKey, final byte[] maxKey) {
        this.doInTransaction(new Action<Void>(){

            @Override
            public Void apply(KVStore kv) {
                kv.removeRange(minKey, maxKey);
                return null;
            }
        });
    }

    @Override
    public void adjustCounter(final byte[] key, final long amount) {
        this.doInTransaction(new Action<Void>(){

            @Override
            public Void apply(KVStore kv) {
                kv.adjustCounter(key, amount);
                return null;
            }
        });
    }

    @Override
    public byte[] encodeCounter(long value) {
        return this.doInTransaction(kv -> kv.encodeCounter(value));
    }

    @Override
    public long decodeCounter(byte[] bytes) {
        return this.doInTransaction(kv -> kv.decodeCounter(bytes));
    }

    @Override
    @PostConstruct
    public void start() {
        this.kvdb.start();
    }

    @Override
    @PreDestroy
    public void stop() {
        this.kvdb.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableKVStore snapshot() {
        KVTransaction kvtx = this.kvdb.createTransaction();
        boolean success = false;
        try {
            try {
                kvtx.setTimeout(Integer.MAX_VALUE);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            SnapshotKVStore kvstore = new SnapshotKVStore(kvtx);
            success = true;
            SnapshotKVStore snapshotKVStore = kvstore;
            return snapshotKVStore;
        }
        finally {
            if (!success) {
                kvtx.rollback();
            }
        }
    }

    @Override
    public void mutate(final Mutations mutations, boolean sync) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        this.doInTransaction(new Action<Void>(){

            @Override
            public Void apply(KVStore kv) {
                Writes.apply(mutations, kv);
                return null;
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[kvdb=" + this.kvdb + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R doInTransaction(Action<R> action) {
        int count = 0;
        while (true) {
            try {
                KVTransaction kvtx = this.kvdb.createTransaction();
                boolean success = false;
                try {
                    R result = action.apply(kvtx);
                    success = true;
                    R r = result;
                    return r;
                }
                finally {
                    if (success) {
                        kvtx.commit();
                    } else {
                        kvtx.rollback();
                    }
                }
            }
            catch (RetryTransactionException e) {
                if (count++ >= 3) throw e;
                Thread.yield();
                continue;
            }
            break;
        }
    }

    private static class SnapshotKVStore
    extends ForwardingKVStore
    implements CloseableKVStore {
        private final KVTransaction kvtx;
        private final UnmodifiableKVStore delegate;
        private volatile boolean closed;

        SnapshotKVStore(KVTransaction kvtx) {
            this.kvtx = kvtx;
            this.delegate = new UnmodifiableKVStore(this.kvtx);
        }

        @Override
        protected UnmodifiableKVStore delegate() {
            return this.delegate;
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.closed) {
                    LoggerFactory.getLogger(this.getClass()).warn(this + " leaked without invoking close()");
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.kvtx.rollback();
        }
    }

    private static interface Action<R> {
        public R apply(KVStore var1);
    }
}

