/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.dellroad.stuff.java.Predicate;
import org.dellroad.stuff.java.TimedWait;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.mvcc.Lock;
import org.jsimpledb.kv.mvcc.LockOwner;
import org.jsimpledb.util.ByteUtil;

public class LockManager {
    private static final long TEN_YEARS_MILLIS = 315360000000L;
    private final Object lockObject;
    private final HashMap<LockOwner, Long> lockTimes = new HashMap();
    private final TreeSet<Lock> locksByMin = new TreeSet<Lock>(Lock.MIN_COMPARATOR);
    private final TreeSet<Lock> locksByMax = new TreeSet<Lock>(Lock.MAX_COMPARATOR);
    private final long nanoBasis = System.nanoTime();
    private long holdTimeout;

    public LockManager() {
        this(null);
    }

    public LockManager(Object lockObject) {
        this.lockObject = lockObject != null ? lockObject : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoldTimeout() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.holdTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHoldTimeout(long holdTimeout) {
        Preconditions.checkArgument((holdTimeout >= 0L ? 1 : 0) != 0, (Object)"holdTimeout < 0");
        Object object = this.lockObject;
        synchronized (object) {
            this.holdTimeout = Math.min(holdTimeout, 315360000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(LockOwner owner, byte[] minKey, byte[] maxKey, boolean write, long waitTimeout) throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"null owner");
            Preconditions.checkArgument((waitTimeout >= 0L ? 1 : 0) != 0, (Object)"waitTimeout < 0");
            waitTimeout = Math.min(waitTimeout, 315360000000L);
            long lockerRemaining = this.checkHoldTimeout(owner);
            if (lockerRemaining == -1L) {
                return LockResult.HOLD_TIMEOUT_EXPIRED;
            }
            Lock lock = new Lock(owner, minKey, maxKey, write);
            LockChecker lockChecker = new LockChecker(lock);
            if (!lockChecker.test()) {
                long timeToWait = Math.min(waitTimeout, lockChecker.getTimeRemaining());
                if (lockerRemaining != 0L) {
                    timeToWait = Math.min(timeToWait, lockerRemaining);
                }
                if (!TimedWait.wait((Object)this.lockObject, (long)timeToWait, (Predicate)lockChecker)) {
                    return LockResult.WAIT_TIMEOUT_EXPIRED;
                }
            }
            if (this.checkHoldTimeout(owner) == -1L) {
                return LockResult.HOLD_TIMEOUT_EXPIRED;
            }
            for (Lock that : lockChecker.getMergers()) {
                Lock mergedLock = lock.mergeWith(that);
                if (mergedLock == null) continue;
                this.locksByMin.remove(that);
                this.locksByMax.remove(that);
                owner.locks.remove(that);
                lock = mergedLock;
            }
            this.locksByMin.add(lock);
            this.locksByMax.add(lock);
            owner.locks.add(lock);
            if (!this.lockTimes.containsKey(owner)) {
                long currentTime = System.nanoTime() - this.nanoBasis;
                this.lockTimes.put(owner, currentTime);
            } else assert (this.lockTimes.get(owner) != null);
            return LockResult.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(LockOwner owner, byte[] minKey, byte[] maxKey, boolean write) {
        Object object = this.lockObject;
        synchronized (object) {
            Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"null owner");
            KeyRanges ranges = new KeyRanges(minKey, maxKey);
            for (Lock lock : owner.locks) {
                if (write && !lock.write) continue;
                ranges.remove(lock);
            }
            return ranges.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(LockOwner owner) {
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"null owner");
        Object object = this.lockObject;
        synchronized (object) {
            Long lockTime;
            if (this.lockTimes.containsKey(owner) && (lockTime = this.lockTimes.remove(owner)) == null) {
                return false;
            }
            this.doRelease(owner);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkHoldTimeout(LockOwner owner) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.holdTimeout == 0L) {
                return 0L;
            }
            if (!this.lockTimes.containsKey(owner)) {
                return 0L;
            }
            Long lockTime = this.lockTimes.get(owner);
            if (lockTime == null) {
                return -1L;
            }
            long currentTime = System.nanoTime() - this.nanoBasis;
            long holdDeadline = lockTime + this.holdTimeout * 1000000L;
            long remaining = holdDeadline - currentTime;
            if (remaining <= 0L) {
                this.lockTimes.put(owner, null);
                this.doRelease(owner);
                return -1L;
            }
            return (remaining + 999999L) / 1000000L;
        }
    }

    private void doRelease(LockOwner owner) {
        for (Lock lock : owner.locks) {
            this.locksByMin.remove(lock);
            this.locksByMax.remove(lock);
        }
        owner.locks.clear();
        this.lockObject.notifyAll();
    }

    private long checkLock(Lock lock, List<Lock> mergers) {
        HashSet<Lock> overlaps;
        byte[] lockMin = lock.getMin();
        byte[] lockMax = lock.getMax();
        block0: while (true) {
            TreeSet<Lock> lhs = lockMax == null ? this.locksByMin : this.locksByMin.headSet(Lock.getMinKey(lockMax, false), false);
            NavigableSet<Lock> rhs = this.locksByMax.tailSet(Lock.getMaxKey(ByteUtil.getNextKey((byte[])lockMin), false), true);
            overlaps = new HashSet<Lock>();
            for (Lock other2 : lhs) {
                if (!rhs.contains(other2)) continue;
                if (lock.conflictsWith(other2)) {
                    assert (this.lockTimes.containsKey(other2.owner));
                    long remaining = this.checkHoldTimeout(other2.owner);
                    if (remaining == -1L) continue block0;
                    return Math.max(remaining, 1L);
                }
                overlaps.add(other2);
            }
            break;
        }
        overlaps.stream().filter(other -> lock.mergeWith((Lock)other) != null).forEach(mergers::add);
        return 0L;
    }

    private class LockChecker
    implements Predicate {
        private final Lock lock;
        private final ArrayList<Lock> mergers = new ArrayList();
        private long timeRemaining;

        LockChecker(Lock lock) {
            this.lock = lock;
        }

        public List<Lock> getMergers() {
            return this.mergers;
        }

        public long getTimeRemaining() {
            return this.timeRemaining;
        }

        public boolean test() {
            this.mergers.clear();
            this.timeRemaining = LockManager.this.checkLock(this.lock, this.mergers);
            return this.timeRemaining == 0L;
        }
    }

    public static enum LockResult {
        SUCCESS,
        WAIT_TIMEOUT_EXPIRED,
        HOLD_TIMEOUT_EXPIRED;

    }
}

