/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.mvcc.Reads;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

@ThreadSafe
public class MutableView
extends AbstractKVStore
implements Cloneable {
    @GuardedBy(value="this")
    private KVStore kv;
    @GuardedBy(value="this")
    private Writes writes;
    @GuardedBy(value="this")
    private Reads reads;
    @GuardedBy(value="this")
    private boolean readOnly;

    public MutableView(KVStore kv) {
        this(kv, new Reads(), new Writes());
    }

    public MutableView(KVStore kv, Reads reads, Writes writes) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        Preconditions.checkArgument((writes != null ? 1 : 0) != 0, (Object)"null writes");
        this.kv = kv;
        this.reads = reads;
        this.writes = writes;
    }

    public synchronized KVStore getKVStore() {
        return this.kv;
    }

    public synchronized void setKVStore(KVStore kv) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
    }

    public synchronized Reads getReads() {
        return this.reads;
    }

    public synchronized Writes getWrites() {
        return this.writes;
    }

    public synchronized void disableReadTracking() {
        this.reads = null;
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public synchronized byte[] get(byte[] key) {
        byte[] value = (byte[])this.writes.getPuts().get(key);
        if (value != null) {
            return (byte[])this.applyCounterAdjustment(key, value).clone();
        }
        if (this.writes.getRemoves().contains(key)) {
            return null;
        }
        value = this.kv.get(key);
        this.recordReads(key, ByteUtil.getNextKey((byte[])key));
        if (value != null) {
            value = (byte[])this.applyCounterAdjustment(key, value).clone();
        }
        return value;
    }

    @Override
    public synchronized CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        return new RangeIterator(minKey, maxKey, reverse);
    }

    @Override
    public synchronized void put(byte[] key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"instance is read-only");
        this.writes.getAdjusts().remove(key);
        this.writes.getPuts().put((byte[])key.clone(), (byte[])value.clone());
    }

    @Override
    public synchronized void remove(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"instance is read-only");
        this.writes.getAdjusts().remove(key);
        this.writes.getPuts().remove(key);
        this.writes.getRemoves().add(new KeyRange(key));
    }

    @Override
    public synchronized void removeRange(byte[] minKey, byte[] maxKey) {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"instance is read-only");
        if (minKey == null) {
            minKey = ByteUtil.EMPTY;
        }
        if (maxKey != null) {
            this.writes.getPuts().subMap(minKey, maxKey).clear();
            this.writes.getAdjusts().subMap(minKey, maxKey).clear();
        } else {
            this.writes.getPuts().tailMap(minKey).clear();
            this.writes.getAdjusts().tailMap(minKey).clear();
        }
        this.writes.getRemoves().add(new KeyRange(minKey, maxKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeCounter(long value) {
        KVStore currentKV;
        MutableView mutableView = this;
        synchronized (mutableView) {
            currentKV = this.kv;
        }
        return currentKV.encodeCounter(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long decodeCounter(byte[] bytes) {
        KVStore currentKV;
        MutableView mutableView = this;
        synchronized (mutableView) {
            currentKV = this.kv;
        }
        return currentKV.decodeCounter(bytes);
    }

    @Override
    public synchronized void adjustCounter(byte[] key, long amount) {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"instance is read-only");
        byte[] putValue = (byte[])this.writes.getPuts().get(key);
        if (putValue != null) {
            long value;
            try {
                value = this.kv.decodeCounter(putValue);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            this.writes.getPuts().put(key, this.kv.encodeCounter(value + amount));
            return;
        }
        if (this.writes.getRemoves().contains(key)) {
            return;
        }
        Long oldAdjust = (Long)this.writes.getAdjusts().get(key);
        if (oldAdjust != null) {
            amount += oldAdjust.longValue();
        }
        if (amount != 0L) {
            this.writes.getAdjusts().put(key, amount);
        } else if (oldAdjust != null) {
            this.writes.getAdjusts().remove(key);
        }
    }

    public synchronized MutableView clone() {
        MutableView clone;
        try {
            clone = (MutableView)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.reads != null) {
            clone.reads = this.reads.clone();
        }
        clone.writes = this.writes.clone();
        return clone;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[writes=" + this.writes + (this.reads != null ? ",reads=" + this.reads : "") + (this.readOnly ? ",r/o" : "") + "]";
    }

    private synchronized byte[] applyCounterAdjustment(byte[] key, byte[] value) {
        long counterValue;
        assert (key != null);
        Long adjust = (Long)this.writes.getAdjusts().get(key);
        if (adjust == null || adjust == 0L) {
            return value;
        }
        try {
            counterValue = this.kv.decodeCounter(value);
        }
        catch (IllegalArgumentException e) {
            return value;
        }
        byte[] adjustedValue = this.kv.encodeCounter(counterValue + adjust);
        assert (adjustedValue != null);
        return adjustedValue;
    }

    private synchronized void recordReads(byte[] minKey, byte[] maxKey) {
        if (this.reads == null) {
            return;
        }
        KeyRange range = new KeyRange(minKey != null ? minKey : ByteUtil.EMPTY, maxKey);
        if (this.writes.getRemoves().contains(range)) {
            return;
        }
        if (range.isSingleKey() && this.writes.getPuts().containsKey(range.getMin())) {
            return;
        }
        this.reads.add(range);
    }

    @ThreadSafe
    private class RangeIterator
    implements CloseableIterator<KVPair> {
        private final boolean reverse;
        private final byte[] limit;
        @GuardedBy(value="this")
        private KVStore kv;
        @GuardedBy(value="this")
        private byte[] cursor;
        @GuardedBy(value="this")
        private KVPair next;
        @GuardedBy(value="this")
        private byte[] removeKey;
        @GuardedBy(value="this")
        private boolean finished;
        @GuardedBy(value="this")
        private CloseableIterator<KVPair> kviter;
        @GuardedBy(value="this")
        private KVPair kvnext;
        @GuardedBy(value="this")
        private KVPair putnext;
        @GuardedBy(value="this")
        private boolean putdone;

        RangeIterator(byte[] minKey, byte[] maxKey, boolean reverse) {
            assert (Thread.holdsLock(MutableView.this));
            if (minKey == null) {
                minKey = ByteUtil.EMPTY;
            }
            this.kv = MutableView.this.kv;
            this.kviter = this.kv.getRange(minKey, maxKey, reverse);
            this.cursor = reverse ? maxKey : minKey;
            this.limit = reverse ? minKey : maxKey;
            this.reverse = reverse;
        }

        public synchronized boolean hasNext() {
            return this.next != null || this.findNext();
        }

        public synchronized KVPair next() {
            if (this.next == null && !this.findNext()) {
                throw new NoSuchElementException();
            }
            KVPair pair = this.next;
            assert (pair != null);
            this.removeKey = pair.getKey();
            this.next = null;
            return pair;
        }

        public synchronized void remove() {
            Preconditions.checkState((this.removeKey != null ? 1 : 0) != 0);
            MutableView.this.remove(this.removeKey);
            this.removeKey = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean findNext() {
            byte[] skipMax;
            byte[] skipMin;
            byte[] readStart;
            assert (this.next == null);
            assert (this.cursor != null || this.reverse);
            assert (this.limit != null || !this.reverse);
            assert (this.kviter != null || this.kvnext == null);
            if (this.finished) {
                return false;
            }
            MutableView mutableView = MutableView.this;
            synchronized (mutableView) {
                if (this.kviter != null && this.kv != MutableView.this.kv) {
                    this.closeKVStoreIterator();
                    this.kv = MutableView.this.kv;
                    this.kviter = this.reverse ? this.kv.getRange(this.limit, this.cursor, true) : this.kv.getRange(this.cursor, this.limit, false);
                }
                readStart = this.cursor;
                if (this.kviter != null && this.kvnext == null) {
                    KeyRanges removes = MutableView.this.writes.getRemoves();
                    while (true) {
                        byte[] iterMax;
                        byte[] iterMin;
                        byte[] removeRangeEnd;
                        if (!this.kviter.hasNext()) {
                            this.closeKVStoreIterator();
                            break;
                        }
                        this.kvnext = (KVPair)this.kviter.next();
                        assert (this.kvnext != null);
                        assert (!this.isPastLimit(this.kvnext.getKey()));
                        assert (this.isPast(this.kvnext.getKey(), this.cursor)) : "key " + ByteUtil.toString((byte[])this.kvnext.getKey()) + " is not past cursor " + ByteUtil.toString((byte[])this.cursor);
                        KeyRange[] ranges = removes.findKey(this.kvnext.getKey());
                        if (ranges[0] != ranges[1] || ranges[0] == null) break;
                        KeyRange removeRange = ranges[0];
                        byte[] byArray = removeRangeEnd = this.reverse ? removeRange.getMin() : removeRange.getMax();
                        if (this.reverse) {
                            byte[] removeRangeStart = removeRange.getMax();
                            if (readStart != null && (removeRangeStart == null || ByteUtil.compare((byte[])readStart, (byte[])removeRangeStart) <= 0)) {
                                readStart = removeRangeEnd;
                            }
                        } else if (removeRange.contains(readStart)) {
                            readStart = removeRangeEnd;
                        }
                        if (removeRangeEnd == null || this.isPastLimit(removeRangeEnd) || this.reverse && Arrays.equals(removeRangeEnd, this.limit)) {
                            this.closeKVStoreIterator();
                            break;
                        }
                        this.closeKVStoreIterator();
                        if (this.reverse) {
                            iterMin = this.limit;
                            iterMax = removeRangeEnd;
                        } else {
                            iterMin = removeRangeEnd;
                            iterMax = this.limit;
                        }
                        this.kviter = MutableView.this.kv.getRange(iterMin, iterMax, this.reverse);
                    }
                }
                if (!this.putdone && this.putnext == null) {
                    Map.Entry<byte[], byte[]> putEntry = this.reverse ? (this.cursor != null ? MutableView.this.writes.getPuts().lowerEntry(this.cursor) : MutableView.this.writes.getPuts().lastEntry()) : MutableView.this.writes.getPuts().ceilingEntry(this.cursor);
                    if (putEntry == null || this.isPastLimit(putEntry.getKey())) {
                        this.putnext = null;
                        this.putdone = true;
                    } else {
                        this.putnext = new KVPair((byte[])putEntry.getKey().clone(), (byte[])putEntry.getValue().clone());
                    }
                }
            }
            if (this.kvnext == null && this.putnext == null) {
                this.next = null;
            } else if (this.kvnext == null) {
                this.next = this.putnext;
                this.putnext = null;
            } else if (this.putnext == null) {
                this.next = this.kvnext;
                this.kvnext = null;
            } else {
                int diff;
                int n = diff = this.reverse ? ByteUtil.compare((byte[])this.kvnext.getKey(), (byte[])this.putnext.getKey()) : ByteUtil.compare((byte[])this.putnext.getKey(), (byte[])this.kvnext.getKey());
                if (diff <= 0) {
                    this.next = this.putnext;
                    this.putnext = null;
                    if (diff == 0) {
                        this.kvnext = null;
                    }
                } else {
                    this.next = this.kvnext;
                    this.kvnext = null;
                }
            }
            if (this.reverse) {
                skipMin = this.next != null ? this.next.getKey() : this.limit;
                skipMax = readStart;
            } else {
                skipMin = readStart;
                byte[] byArray = skipMax = this.next != null ? ByteUtil.getNextKey((byte[])this.next.getKey()) : this.limit;
            }
            if (skipMin != null && (skipMax == null || ByteUtil.compare((byte[])skipMin, (byte[])skipMax) < 0)) {
                MutableView.this.recordReads(skipMin, skipMax);
            }
            if (this.next == null) {
                this.finished = true;
                return false;
            }
            byte[] adjustedValue = MutableView.this.applyCounterAdjustment(this.next.getKey(), this.next.getValue());
            if (adjustedValue != this.next.getValue()) {
                this.next = new KVPair(this.next.getKey(), adjustedValue);
            }
            this.cursor = this.reverse ? this.next.getKey() : ByteUtil.getNextKey((byte[])this.next.getKey());
            return true;
        }

        private boolean isPastLimit(byte[] key) {
            return this.isPast(key, this.limit);
        }

        private boolean isPast(byte[] key, byte[] mark) {
            return this.reverse ? mark == null || ByteUtil.compare((byte[])key, (byte[])mark) < 0 : mark != null && ByteUtil.compare((byte[])key, (byte[])mark) >= 0;
        }

        private void closeKVStoreIterator() {
            assert (Thread.holdsLock(this));
            if (this.kviter != null) {
                this.kviter.close();
                this.kviter = null;
            }
            this.kvnext = null;
        }

        public synchronized void close() {
            this.closeKVStoreIterator();
            this.putdone = true;
        }
    }
}

