/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableForwardingKVStore
extends ForwardingKVStore
implements CloseableKVStore {
    private static final boolean TRACK_ALLOCATIONS = Boolean.parseBoolean(System.getProperty(CloseableForwardingKVStore.class.getName() + ".TRACK_ALLOCATIONS", "false"));
    private final KVStore kvstore;
    private final Closeable closeable;
    private final Throwable allocation;
    private boolean closed;

    public CloseableForwardingKVStore(KVStore kvstore) {
        this(kvstore, null);
    }

    public CloseableForwardingKVStore(CloseableKVStore kvstore) {
        this(kvstore, kvstore);
    }

    public CloseableForwardingKVStore(KVStore kvstore, Closeable resource) {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        this.kvstore = kvstore;
        this.closeable = resource;
        this.allocation = TRACK_ALLOCATIONS ? new Throwable("allocated here") : null;
    }

    @Override
    protected KVStore delegate() {
        return this.kvstore;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            boolean leaked;
            CloseableForwardingKVStore closeableForwardingKVStore = this;
            synchronized (closeableForwardingKVStore) {
                leaked = !this.closed;
            }
            if (leaked) {
                Logger log = LoggerFactory.getLogger(this.getClass());
                String msg = this.getClass().getSimpleName() + "[" + this.closeable + "] leaked without invoking close()";
                if (this.allocation != null) {
                    log.warn(msg, this.allocation);
                } else {
                    log.warn(msg);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

