/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableMap;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.AbstractKVNavigableMap;
import org.jsimpledb.kv.util.KVNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public class KVNavigableMap
extends AbstractKVNavigableMap<byte[], byte[]> {
    public KVNavigableMap(KVStore kv) {
        this(kv, false, null, null);
    }

    public KVNavigableMap(KVStore kv, byte[] prefix) {
        this(kv, false, KeyRange.forPrefix(prefix), null);
    }

    protected KVNavigableMap(KVStore kv, boolean reversed, KeyRange keyRange, KeyFilter keyFilter) {
        this(kv, reversed, keyRange, keyFilter, KVNavigableSet.createBounds(keyRange));
    }

    private KVNavigableMap(KVStore kv, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<byte[]> bounds) {
        super(kv, false, reversed, keyRange, keyFilter, bounds);
    }

    public Comparator<byte[]> comparator() {
        return this.reversed ? Collections.reverseOrder(ByteUtil.COMPARATOR) : ByteUtil.COMPARATOR;
    }

    public byte[] put(byte[] key, byte[] value) {
        Preconditions.checkArgument((boolean)this.isVisible(key), (Object)"key is out of range or filtered out");
        byte[] previousValue = this.kv.get(key);
        this.kv.put(key, value);
        return previousValue;
    }

    public byte[] remove(Object obj) {
        if (!(obj instanceof byte[])) {
            return null;
        }
        byte[] key = (byte[])obj;
        if (!this.isVisible(key)) {
            return null;
        }
        byte[] previousValue = this.kv.get(key);
        if (previousValue != null) {
            this.kv.remove(key);
        }
        return previousValue;
    }

    public void clear() {
        this.navigableKeySet().clear();
    }

    public boolean containsKey(Object obj) {
        if (!(obj instanceof byte[])) {
            return false;
        }
        byte[] key = (byte[])obj;
        if (!this.isVisible(key)) {
            return false;
        }
        return this.kv.get(key) != null;
    }

    @Override
    protected void encodeKey(ByteWriter writer, Object obj) {
        Preconditions.checkArgument((boolean)(obj instanceof byte[]), (Object)"key is not a byte[]");
        writer.write((byte[])obj);
    }

    @Override
    protected byte[] decodeKey(ByteReader reader) {
        return reader.getBytes();
    }

    @Override
    protected byte[] decodeValue(KVPair pair) {
        return pair.getValue();
    }

    @Override
    protected NavigableMap<byte[], byte[]> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<byte[]> newBounds) {
        return new KVNavigableMap(this.kv, newReversed, newKeyRange, newKeyFilter, newBounds);
    }
}

