/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class KeyWatchTracker
implements Closeable {
    public static final long DEFAULT_CAPACITY = 10000L;
    public static final long DEFAULT_MAXIMUM_LIFETIME = 2592000L;
    public static final boolean DEFAULT_WEAK_REFERENCE = false;
    @GuardedBy(value="this")
    private final TreeMap<byte[], KeyInfo> keyInfos = new TreeMap(ByteUtil.COMPARATOR);
    private final Cache<KeyFuture, KeyInfo> futureMap;
    private final ExecutorService notifyExecutor;

    public KeyWatchTracker() {
        this(10000L, 2592000L, false);
    }

    public KeyWatchTracker(long capacity, long maxLifetime, boolean weakReferences) {
        Preconditions.checkArgument((capacity > 0L ? 1 : 0) != 0, (Object)"capacity <= 0");
        Preconditions.checkArgument((maxLifetime > 0L ? 1 : 0) != 0, (Object)"maxLifetime <= 0");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(capacity).expireAfterWrite(maxLifetime, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<KeyFuture, KeyInfo>(){

            public void onRemoval(RemovalNotification<KeyFuture, KeyInfo> notification) {
                ((KeyInfo)notification.getValue()).handleRemoval((KeyFuture)((Object)notification.getKey()));
            }
        });
        if (weakReferences) {
            cacheBuilder = cacheBuilder.weakKeys();
        }
        this.futureMap = cacheBuilder.build();
        this.notifyExecutor = Executors.newSingleThreadExecutor(action -> {
            Thread thread = new Thread(action);
            thread.setName("Key Watch Notify");
            return thread;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ListenableFuture<Void> register(byte[] key) {
        KeyInfo keyInfo;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        KeyWatchTracker keyWatchTracker = this;
        synchronized (keyWatchTracker) {
            keyInfo = this.keyInfos.get(key);
            if (keyInfo == null) {
                key = (byte[])key.clone();
                keyInfo = new KeyInfo(key);
                this.keyInfos.put(key, keyInfo);
            }
        }
        return keyInfo.createFuture();
    }

    public synchronized int getNumKeysWatched() {
        return this.keyInfos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trigger(byte[] key) {
        KeyInfo keyInfo;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        KeyWatchTracker keyWatchTracker = this;
        synchronized (keyWatchTracker) {
            keyInfo = this.keyInfos.remove(key);
            if (keyInfo == null) {
                return false;
            }
        }
        keyInfo.triggerAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trigger(Iterable<byte[]> keys) {
        Preconditions.checkArgument((keys != null ? 1 : 0) != 0, (Object)"null keys");
        ArrayList<KeyInfo> triggerList = new ArrayList<KeyInfo>();
        KeyWatchTracker keyWatchTracker = this;
        synchronized (keyWatchTracker) {
            for (byte[] key : keys) {
                KeyInfo keyInfo = this.keyInfos.remove(key);
                if (keyInfo == null) continue;
                triggerList.add(keyInfo);
            }
        }
        if (triggerList.isEmpty()) {
            return false;
        }
        triggerList.forEach(KeyInfo::triggerAll);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trigger(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        ArrayList<Object> triggerList = new ArrayList<Object>();
        KeyWatchTracker keyWatchTracker = this;
        synchronized (keyWatchTracker) {
            NavigableMap<byte[], KeyInfo> subMap = range.getMax() != null ? this.keyInfos.subMap(range.getMin(), true, range.getMax(), false) : this.keyInfos.tailMap(range.getMin(), true);
            triggerList.addAll(subMap.values());
            subMap.clear();
        }
        if (triggerList.isEmpty()) {
            return false;
        }
        triggerList.forEach((Consumer<Object>)((Consumer<KeyInfo>)KeyInfo::triggerAll));
        return true;
    }

    public boolean trigger(Mutations mutations) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        boolean result = false;
        for (KeyRange keyRange : mutations.getRemoveRanges()) {
            result |= this.trigger(keyRange);
        }
        result |= this.trigger(Iterables.transform(mutations.getPutPairs(), Map.Entry::getKey));
        return result |= this.trigger(Iterables.transform(mutations.getAdjustPairs(), Map.Entry::getKey));
    }

    public boolean triggerAll() {
        return this.trigger(KeyRange.FULL);
    }

    public void failAll(Exception e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null e");
        for (KeyInfo keyInfo : this.removeAllKeyInfos()) {
            keyInfo.failAll(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void absorb(KeyWatchTracker that) {
        KeyInfo[] thatKeyInfos;
        for (KeyInfo thatKeyInfo : thatKeyInfos = that.removeAllKeyInfos()) {
            KeyInfo thisKeyInfo;
            byte[] key = thatKeyInfo.getKey();
            KeyWatchTracker keyWatchTracker = this;
            synchronized (keyWatchTracker) {
                thisKeyInfo = this.keyInfos.get(key);
                if (thisKeyInfo == null) {
                    thisKeyInfo = new KeyInfo(key);
                    this.keyInfos.put(key, thisKeyInfo);
                }
            }
            for (KeyFuture future : thatKeyInfo.removeAllFutures()) {
                thisKeyInfo.addFuture(future);
                future.setOwner(this.futureMap);
                if (!future.isDone()) continue;
                this.futureMap.invalidate((Object)future);
            }
        }
        that.futureMap.invalidateAll();
    }

    private synchronized KeyInfo[] removeAllKeyInfos() {
        Collection<KeyInfo> allKeyInfos = this.keyInfos.values();
        KeyInfo[] result = allKeyInfos.toArray(new KeyInfo[allKeyInfos.size()]);
        this.keyInfos.clear();
        return result;
    }

    @Override
    public void close() {
        this.failAll(new Exception("key watch tracker closed"));
        this.notifyExecutor.shutdownNow();
        try {
            this.notifyExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class KeyFuture
    extends AbstractFuture<Void> {
        private volatile Cache<KeyFuture, KeyInfo> futureMap;

        KeyFuture(Cache<KeyFuture, KeyInfo> futureMap) {
            this.futureMap = futureMap;
        }

        protected boolean set(Void value) {
            this.futureMap.invalidate((Object)this);
            return super.set((Object)value);
        }

        protected boolean setException(Throwable t) {
            this.futureMap.invalidate((Object)this);
            return super.setException(t);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.futureMap.invalidate((Object)this);
            return super.cancel(mayInterruptIfRunning);
        }

        Cache<KeyFuture, KeyInfo> getOwner() {
            return this.futureMap;
        }

        void setOwner(Cache<KeyFuture, KeyInfo> futureMap) {
            this.futureMap = futureMap;
        }
    }

    private class KeyInfo {
        private final byte[] key;
        @GuardedBy(value="this")
        private final HashSet<KeyFuture> futures = new HashSet(1);

        KeyInfo(byte[] key) {
            assert (key != null);
            this.key = key;
        }

        public byte[] getKey() {
            return this.key;
        }

        KeyFuture createFuture() {
            KeyFuture future = new KeyFuture((Cache<KeyFuture, KeyInfo>)KeyWatchTracker.this.futureMap);
            this.addFuture(future);
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addFuture(KeyFuture future) {
            KeyWatchTracker.this.futureMap.put((Object)future, (Object)this);
            KeyInfo keyInfo = this;
            synchronized (keyInfo) {
                this.futures.add(future);
            }
        }

        void handleRemoval(KeyFuture future) {
            if (this.removeFuture(future) && future.getOwner() == KeyWatchTracker.this.futureMap) {
                this.notifyFuture(future, null);
            }
        }

        void triggerAll() {
            for (KeyFuture future : this.removeAllFutures()) {
                this.notifyFuture(future, null);
            }
        }

        void failAll(Exception e) {
            assert (e != null);
            for (KeyFuture future : this.removeAllFutures()) {
                this.notifyFuture(future, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeFuture(KeyFuture future) {
            boolean removed;
            KeyInfo keyInfo = this;
            synchronized (keyInfo) {
                removed = this.futures.remove((Object)future);
                if (this.futures.isEmpty()) {
                    KeyWatchTracker keyWatchTracker = KeyWatchTracker.this;
                    synchronized (keyWatchTracker) {
                        KeyWatchTracker.this.keyInfos.remove(this.key);
                    }
                }
            }
            return removed;
        }

        private void notifyFuture(final KeyFuture future, final Exception e) {
            KeyWatchTracker.this.notifyExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (e != null) {
                            future.setException(e);
                        } else {
                            future.set(null);
                        }
                    }
                    catch (Throwable t) {
                        LoggerFactory.getLogger(this.getClass()).error("exception from key watch listener", t);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ArrayList<KeyFuture> removeAllFutures() {
            ArrayList<KeyFuture> futureList;
            KeyInfo keyInfo = this;
            synchronized (keyInfo) {
                futureList = new ArrayList<KeyFuture>(this.futures);
                this.futures.clear();
            }
            KeyWatchTracker.this.futureMap.invalidateAll(futureList);
            return futureList;
        }
    }
}

