/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

@ThreadSafe
public class NavigableMapKVStore
extends AbstractKVStore
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8112493152056118516L;
    private ConcurrentSkipListMap<byte[], byte[]> map;

    public NavigableMapKVStore() {
        this(new ConcurrentSkipListMap<byte[], byte[]>(ByteUtil.COMPARATOR));
    }

    public NavigableMapKVStore(ConcurrentSkipListMap<byte[], byte[]> map) {
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"null map");
        Preconditions.checkArgument((map.comparator() != null && map.comparator().compare(ByteUtil.parse((String)"00"), ByteUtil.parse((String)"ff")) < 0 ? 1 : 0) != 0, (Object)"invalid comparator");
        this.map = map;
    }

    public ConcurrentSkipListMap<byte[], byte[]> getNavigableMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public byte[] get(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        byte[] value = this.map.get(key);
        return value != null ? (byte[])value.clone() : null;
    }

    @Override
    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        Map.Entry<byte[], byte[]> entry = minKey != null ? this.map.ceilingEntry(minKey) : this.map.firstEntry();
        return entry != null && (maxKey == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])maxKey) < 0) ? new KVPair((byte[])entry.getKey().clone(), (byte[])entry.getValue().clone()) : null;
    }

    @Override
    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        Map.Entry<byte[], byte[]> entry = maxKey != null ? this.map.lowerEntry(maxKey) : this.map.lastEntry();
        return entry != null && (minKey == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])minKey) >= 0) ? new KVPair((byte[])entry.getKey().clone(), (byte[])entry.getValue().clone()) : null;
    }

    @Override
    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        NavigableMap<byte[], Object> rangeMap = this.map;
        if (minKey != null && maxKey != null) {
            rangeMap = rangeMap.subMap(minKey, true, maxKey, false);
        } else if (minKey != null) {
            rangeMap = rangeMap.tailMap(minKey, true);
        } else if (maxKey != null) {
            rangeMap = rangeMap.headMap(maxKey, false);
        }
        if (reverse) {
            rangeMap = rangeMap.descendingMap();
        }
        return CloseableIterator.wrap((Iterator)Iterators.transform(rangeMap.entrySet().iterator(), entry -> new KVPair((byte[])((byte[])entry.getKey()).clone(), (byte[])((byte[])entry.getValue()).clone())));
    }

    @Override
    public void put(byte[] key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.map.put((byte[])key.clone(), (byte[])value.clone());
    }

    @Override
    public void remove(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        this.map.remove(key);
    }

    @Override
    public void removeRange(byte[] minKey, byte[] maxKey) {
        if (minKey == null && maxKey == null) {
            this.map.clear();
        } else if (minKey == null) {
            this.map.headMap((Object)maxKey).clear();
        } else if (maxKey == null) {
            this.map.tailMap((Object)minKey).clear();
        } else {
            this.map.subMap((Object)minKey, (Object)maxKey).clear();
        }
    }

    public NavigableMapKVStore clone() {
        NavigableMapKVStore clone;
        try {
            clone = (NavigableMapKVStore)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.map = this.map.clone();
        return clone;
    }
}

