/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.util.ForwardingKVStore;

public class UnmodifiableKVStore
extends ForwardingKVStore {
    private final KVStore kvstore;

    public UnmodifiableKVStore(KVStore kvstore) {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        this.kvstore = kvstore;
    }

    @Override
    protected KVStore delegate() {
        return this.kvstore;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void remove(byte[] key) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void adjustCounter(byte[] key, long amount) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }
}

