/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.simple;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.simple.Mutation;
import org.jsimpledb.kv.util.KeyWatchTracker;

class Put
extends Mutation {
    private final byte[] value;

    Put(byte[] key, byte[] value) {
        super(key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.value = (byte[])value.clone();
    }

    public byte[] getKey() {
        return this.getMin();
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public Map.Entry<byte[], byte[]> toMapEntry() {
        return new AbstractMap.SimpleEntry<byte[], byte[]>(this.getKey(), this.getValue());
    }

    @Override
    public void apply(KVStore kv) {
        kv.put(this.getKey(), this.getValue());
    }

    @Override
    public boolean trigger(KeyWatchTracker keyWatchTracker) {
        return keyWatchTracker.trigger(this.getKey());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Put that = (Put)((Object)obj);
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.value);
    }
}

