/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TopologicalSorter<E> {
    private final Collection<E> nodes;
    private final EdgeLister<E> edgeLister;
    private final Comparator<? super E> tieBreaker;
    private HashMap<E, Boolean> visited;
    private ArrayList<E> ordering;

    public TopologicalSorter(Collection<E> nodes, EdgeLister<E> edgeLister, Comparator<? super E> tieBreaker) {
        this.nodes = nodes;
        this.edgeLister = edgeLister;
        if (tieBreaker == null) {
            tieBreaker = this.getDefaultTieBreaker();
        }
        this.tieBreaker = tieBreaker;
    }

    public TopologicalSorter(Collection<E> nodes, EdgeLister<E> edgeLister) {
        this(nodes, edgeLister, null);
    }

    public List<E> sort() {
        ArrayList<E> startList = Collections.list(Collections.enumeration(this.nodes));
        Collections.sort(startList, this.getTieBreaker(true));
        this.visited = new HashMap(startList.size());
        this.ordering = new ArrayList(startList.size());
        for (E node : startList) {
            this.visit(node, true);
        }
        Collections.reverse(this.ordering);
        return this.ordering;
    }

    public List<E> sortEdgesReversed() {
        ArrayList<E> startList = Collections.list(Collections.enumeration(this.nodes));
        Collections.sort(startList, this.getTieBreaker(false));
        this.visited = new HashMap(startList.size());
        this.ordering = new ArrayList(startList.size());
        for (E node : startList) {
            this.visit(node, false);
        }
        return this.ordering;
    }

    private void visit(E node, boolean reverse) {
        Boolean state = this.visited.get(node);
        if (state != null) {
            if (!state.booleanValue()) {
                throw new IllegalArgumentException("cycle in graph containing " + node);
            }
            return;
        }
        this.visited.put(node, false);
        ArrayList<E> targets = Collections.list(Collections.enumeration(this.edgeLister.getOutEdges(node)));
        Collections.sort(targets, this.getTieBreaker(reverse));
        for (E target : targets) {
            this.visit(target, reverse);
        }
        this.ordering.add(node);
        this.visited.put(node, true);
    }

    private Comparator<? super E> getDefaultTieBreaker() {
        final HashMap<E, Integer> orderMap = new HashMap<E, Integer>(this.nodes.size());
        int posn = 0;
        for (E node : this.nodes) {
            orderMap.put(node, posn++);
        }
        return new Comparator<E>(){

            @Override
            public int compare(E node1, E node2) {
                return (Integer)orderMap.get(node1) - (Integer)orderMap.get(node2);
            }
        };
    }

    private Comparator<? super E> getTieBreaker(boolean reverse) {
        if (reverse) {
            return Collections.reverseOrder(this.tieBreaker);
        }
        return this.tieBreaker;
    }

    public static interface EdgeLister<E> {
        public Set<E> getOutEdges(E var1);
    }
}

