/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class AtomicUpdateFileOutputStream
extends FileOutputStream {
    private final File targetFile;
    private File tempFile;
    private long timestamp;

    public AtomicUpdateFileOutputStream(File targetFile, File tempFile) throws FileNotFoundException {
        super(tempFile);
        this.tempFile = tempFile;
        if (targetFile == null) {
            throw new NullPointerException("null targetFile");
        }
        this.targetFile = targetFile;
    }

    public AtomicUpdateFileOutputStream(File targetFile) throws IOException {
        this(targetFile, File.createTempFile("atomicupdate", null, targetFile.getAbsoluteFile().getParentFile()));
    }

    public synchronized File getTargetFile() {
        return this.targetFile;
    }

    public synchronized File getTempFile() {
        return this.tempFile;
    }

    public synchronized void cancel() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.tempFile == null) {
            return;
        }
        long newTimestamp = this.tempFile.lastModified();
        try {
            Files.move(this.tempFile.toPath(), this.targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.tempFile = null;
        }
        finally {
            if (this.tempFile != null) {
                this.cancel();
            }
        }
        this.timestamp = newTimestamp;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    protected void finalize() throws IOException {
        try {
            if (this.tempFile != null) {
                this.cancel();
            }
        }
        finally {
            super.finalize();
        }
    }
}

