/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.main;

import org.dellroad.stuff.main.MainClass;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class ContextMainClass
extends MainClass {
    protected ClassPathXmlApplicationContext context;

    private void openContext() {
        String path = this.getContextLocation();
        this.log.info("opening application context " + path);
        this.context = new ClassPathXmlApplicationContext(path, this.getClass());
    }

    private void closeContext() {
        this.log.info("closing application context");
        this.context.close();
        this.context = null;
    }

    protected String getContextLocation() {
        return this.getClass().getSimpleName() + ".xml";
    }

    protected void autowire() {
        this.log.info("autowiring instance of " + this.getClass() + " using " + this.context.getAutowireCapableBeanFactory());
        this.context.getAutowireCapableBeanFactory().autowireBean((Object)this);
    }

    @Override
    public int run(String[] args) throws Exception {
        this.openContext();
        try {
            int n = this.runInContext(args);
            return n;
        }
        catch (Exception e) {
            this.log.error("caught exception during execution", (Throwable)e);
            throw e;
        }
        finally {
            this.closeContext();
        }
    }

    protected abstract int runInContext(String[] var1) throws Exception;
}

