/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayDeque;
import org.dellroad.stuff.net.ChannelNetwork;
import org.dellroad.stuff.net.SelectorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelConnection
implements SelectorSupport.IOHandler {
    private static final int MIN_DIRECT_BUFFER_SIZE = 128;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ChannelNetwork network;
    protected final String peer;
    protected final SelectableChannel inputChannel;
    protected final SelectableChannel outputChannel;
    protected final SelectionKey inputSelectionKey;
    protected final SelectionKey outputSelectionKey;
    private final ArrayDeque<ByteBuffer> output = new ArrayDeque();
    private ByteBuffer inbuf;
    private long queueSize;
    private long lastActiveTime;
    private boolean readingLength;
    private boolean closed;

    protected ChannelConnection(ChannelNetwork network, String peer, SelectableChannel channel) throws IOException {
        this(network, peer, channel, channel);
    }

    protected ChannelConnection(ChannelNetwork network, String peer, SelectableChannel inputChannel, SelectableChannel outputChannel) throws IOException {
        if (network == null) {
            throw new IllegalArgumentException("null network");
        }
        if (peer == null) {
            throw new IllegalArgumentException("null peer");
        }
        if (!(inputChannel instanceof ReadableByteChannel)) {
            throw new IllegalArgumentException("inputChannel must be a ReadableByteChannel");
        }
        if (!(outputChannel instanceof GatheringByteChannel)) {
            throw new IllegalArgumentException("inputChannel must be a GatheringByteChannel");
        }
        this.network = network;
        this.peer = peer;
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.restartIdleTimer();
        this.inputSelectionKey = this.network.createSelectionKey(this.inputChannel, this);
        this.outputSelectionKey = this.outputChannel != this.inputChannel ? this.network.createSelectionKey(this.outputChannel, this) : this.inputSelectionKey;
        this.updateSelection();
        this.inbuf = ByteBuffer.allocate(4);
        this.readingLength = true;
    }

    public String getPeer() {
        return this.peer;
    }

    public SelectableChannel getInputChannel() {
        return this.inputChannel;
    }

    public SelectableChannel getOutputChannel() {
        return this.outputChannel;
    }

    public long getIdleTime() {
        return (System.nanoTime() - this.lastActiveTime) / 1000000L;
    }

    public boolean output(ByteBuffer buf) {
        assert (Thread.holdsLock(this.network));
        if (buf == null) {
            throw new IllegalArgumentException("null buf");
        }
        int length = (buf = buf.asReadOnlyBuffer()).remaining();
        int increment = length + 4;
        if (this.queueSize + (long)increment > this.network.getMaxOutputQueueSize()) {
            return false;
        }
        this.output.add((ByteBuffer)ByteBuffer.allocate(4).putInt(length).flip());
        this.output.add(buf);
        this.queueSize += (long)increment;
        this.updateSelection();
        this.restartIdleTimer();
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[peer=" + this.peer + ",closed=" + this.closed + "]";
    }

    @Override
    public void serviceIO(SelectionKey key) throws IOException {
        assert (this.network.isServiceThread());
        assert (Thread.holdsLock(this.network));
        if (key.isReadable()) {
            this.handleReadable();
        }
        if (key.isWritable()) {
            this.handleWritable();
        }
    }

    @Override
    public void close(Throwable cause) {
        assert (Thread.holdsLock(this.network));
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing " + this + (cause != null ? " due to " + cause : ""));
        }
        try {
            this.inputChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outputChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.network.handleConnectionClosed(this);
    }

    protected void updateSelection() {
        this.network.selectFor(this.inputSelectionKey, 1, true);
        this.network.selectFor(this.outputSelectionKey, 4, !this.output.isEmpty());
    }

    protected void restartIdleTimer() {
        this.lastActiveTime = System.nanoTime();
    }

    private void handleReadable() throws IOException {
        while (true) {
            this.restartIdleTimer();
            long len = ((ReadableByteChannel)((Object)this.inputChannel)).read(this.inbuf);
            if (len == -1L) {
                throw new EOFException("connection closed");
            }
            if (this.inbuf.hasRemaining()) break;
            this.inbuf.flip();
            if (this.readingLength) {
                assert (this.inbuf.remaining() == 4);
                int length = this.inbuf.getInt();
                if (length < 0 || length > this.network.getMaxMessageSize()) {
                    throw new IOException("rec'd message with bogus length " + length);
                }
                this.inbuf = length >= 128 ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
                this.readingLength = false;
                continue;
            }
            this.network.handleMessage(this, this.inbuf);
            this.inbuf = ByteBuffer.allocate(4);
            this.readingLength = true;
        }
        this.restartIdleTimer();
    }

    private void handleWritable() throws IOException {
        boolean queueBecameEmpty = false;
        if (!this.output.isEmpty()) {
            long written = ((GatheringByteChannel)((Object)this.outputChannel)).write(this.output.toArray(new ByteBuffer[this.output.size()]));
            this.queueSize -= written;
            while (!this.output.isEmpty() && !this.output.peekFirst().hasRemaining()) {
                this.output.removeFirst();
            }
            queueBecameEmpty = this.output.isEmpty();
        }
        if (queueBecameEmpty) {
            this.updateSelection();
        }
        this.restartIdleTimer();
        if (queueBecameEmpty) {
            this.network.handleOutputQueueEmpty(this);
        }
    }

    protected void performHousekeeping() throws IOException {
        assert (Thread.holdsLock(this.network));
        assert (this.network.isServiceThread());
        if (this.getIdleTime() >= this.network.getMaxIdleTime()) {
            throw new IOException("connection idle timeout after " + this.getIdleTime() + "ms");
        }
    }
}

