/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import org.dellroad.stuff.java.Predicate;
import org.dellroad.stuff.java.TimedWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectorSupport {
    public static final int DEFAULT_HOUSEKEEPING_INTERVAL = 1000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile Selector selector;
    private ServiceThread serviceThread;
    private volatile int housekeepingInterval = 1000;

    public void setHousekeepingInterval(int housekeepingInterval) {
        if (housekeepingInterval < 0) {
            throw new IllegalArgumentException("housekeepingInterval < 0");
        }
        this.housekeepingInterval = housekeepingInterval;
    }

    public synchronized void start() throws IOException {
        if (this.selector != null) {
            return;
        }
        boolean successful = false;
        try {
            this.selector = Selector.open();
            this.serviceThread = new ServiceThread();
            this.serviceThread.start();
            successful = true;
        }
        finally {
            if (!successful) {
                this.stop();
            }
        }
    }

    public synchronized void stop() {
        if (this.selector == null) {
            return;
        }
        assert (this.serviceThread != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("stopping " + this);
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selector = null;
        }
        this.serviceThread.interrupt();
        if (this.isServiceThread()) {
            return;
        }
        final ServiceThread currentServiceThread = this.serviceThread;
        String failure = null;
        try {
            if (!TimedWait.wait(this, 1000L, new Predicate(){

                @Override
                public boolean test() {
                    return SelectorSupport.this.serviceThread != currentServiceThread;
                }
            })) {
                failure = "timed out";
            }
        }
        catch (InterruptedException e) {
            failure = "interrupted";
            Thread.currentThread().interrupt();
        }
        if (failure != null) {
            this.log.warn(failure + " waiting for service thread " + currentServiceThread + " while stopping " + this + ", giving up");
        }
    }

    protected synchronized SelectionKey createSelectionKey(SelectableChannel channel, IOHandler handler) throws IOException {
        if (channel == null) {
            throw new IllegalArgumentException("null channel");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null handler");
        }
        if (this.selector == null) {
            throw new IllegalArgumentException("not started");
        }
        this.wakeup();
        channel.configureBlocking(false);
        return channel.register(this.selector, 0, handler);
    }

    protected synchronized void selectFor(SelectionKey selectionKey, int ops, boolean enabled) {
        if (selectionKey == null) {
            throw new IllegalArgumentException("null selectionKey");
        }
        if (!(selectionKey.attachment() instanceof IOHandler)) {
            throw new IllegalArgumentException("unrecognized selectionKey");
        }
        this.wakeup();
        int currentOps = selectionKey.interestOps();
        selectionKey.interestOps(enabled ? currentOps | ops : currentOps & ~ops);
    }

    protected void wakeup() {
        assert (Thread.holdsLock(this));
        Selector currentSelector = this.selector;
        if (currentSelector != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("wakeup service thread");
            }
            currentSelector.wakeup();
        }
    }

    protected void serviceHousekeeping() {
    }

    protected void serviceCleanup() {
    }

    protected static String dbg(Iterable<? extends SelectionKey> keys) {
        ArrayList<String> strings = new ArrayList<String>();
        for (SelectionKey selectionKey : keys) {
            strings.add(SelectorSupport.dbg(selectionKey));
        }
        return strings.toString();
    }

    protected static String dbg(SelectionKey key) {
        try {
            return "Key[interest=" + SelectorSupport.dbgOps(key.interestOps()) + ",ready=" + SelectorSupport.dbgOps(key.readyOps()) + ",obj=" + key.attachment() + "]";
        }
        catch (CancelledKeyException e) {
            return "Key[canceled]";
        }
    }

    protected static String dbgOps(int ops) {
        StringBuilder buf = new StringBuilder(4);
        if ((ops & 0x10) != 0) {
            buf.append("A");
        }
        if ((ops & 8) != 0) {
            buf.append("C");
        }
        if ((ops & 1) != 0) {
            buf.append("R");
        }
        if ((ops & 4) != 0) {
            buf.append("W");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void service() throws IOException {
        Selector currentSelector;
        assert (this.isServiceThread());
        block15: while ((currentSelector = this.selector) != null) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[SVC THREAD]: sleeping: keys=" + SelectorSupport.dbg(currentSelector.keys()));
                }
                currentSelector.select(this.housekeepingInterval);
            }
            catch (ClosedSelectorException e) {
                break;
            }
            if (Thread.interrupted() || this.selector == null) break;
            SelectorSupport e = this;
            synchronized (e) {
                if (this.selector == null) {
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[SVC THREAD]: awake: selectedKeys=" + SelectorSupport.dbg(currentSelector.selectedKeys()));
                }
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    IOHandler handler = (IOHandler)key.attachment();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[SVC THREAD]: I/O ready: key=" + SelectorSupport.dbg(key) + " handler=" + handler);
                    }
                    try {
                        handler.serviceIO(key);
                    }
                    catch (IOException e2) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("I/O error from " + handler, (Throwable)e2);
                        }
                        handler.close(e2);
                    }
                    catch (Throwable t) {
                        this.log.error("service error from " + handler, t);
                        handler.close(t);
                    }
                    if (this.selector != null) continue;
                    break block15;
                }
                try {
                    this.serviceHousekeeping();
                }
                catch (Throwable t) {
                    this.log.error("exception during housekeeping", t);
                }
            }
        }
        SelectorSupport selectorSupport = this;
        synchronized (selectorSupport) {
            try {
                this.serviceCleanup();
            }
            catch (Throwable t) {
                this.log.error("exception during cleanup", t);
            }
            if (this.serviceThread == Thread.currentThread()) {
                this.serviceThread = null;
            }
            this.notifyAll();
        }
    }

    protected boolean isServiceThread() {
        return Thread.currentThread().equals(this.serviceThread);
    }

    public static interface IOHandler {
        public void serviceIO(SelectionKey var1) throws IOException;

        public void close(Throwable var1);
    }

    private class ServiceThread
    extends Thread {
        ServiceThread() {
            super("Service Thread for " + SelectorSupport.this);
        }

        @Override
        public void run() {
            try {
                SelectorSupport.this.service();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                SelectorSupport.this.log.error("unexpected error in service thread", t);
            }
            if (SelectorSupport.this.log.isDebugEnabled()) {
                SelectorSupport.this.log.debug(this + " exiting");
            }
        }
    }
}

