/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5369933310249261572L;
    private static final int MAX_REJECT_QUOTE = 15;
    private final String input;
    private int index;

    public ParseContext(String input) {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        this.input = input;
    }

    public String getOriginalInput() {
        return this.input;
    }

    public String getInput() {
        return this.input.substring(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void reset() {
        this.setIndex(0);
    }

    public Matcher matchPrefix(String regex) {
        return this.matchPrefix(Pattern.compile(regex));
    }

    public Matcher matchPrefix(Pattern regex) {
        Matcher matcher = this.tryPattern(regex);
        if (matcher == null) {
            throw this.buildException("expected input matching pattern `" + regex + "'");
        }
        return matcher;
    }

    public boolean tryLiteral(String prefix) {
        boolean match = this.input.startsWith(prefix, this.index);
        if (match) {
            this.index += prefix.length();
        }
        return match;
    }

    public Matcher tryPattern(String pattern) {
        return this.tryPattern(Pattern.compile(pattern));
    }

    public Matcher tryPattern(Pattern regex) {
        Matcher matcher = regex.matcher(this.getInput());
        if (!matcher.lookingAt()) {
            return null;
        }
        this.index += matcher.end();
        return matcher;
    }

    public boolean isEOF() {
        return this.index >= this.input.length();
    }

    public char read() {
        char ch = this.peek();
        ++this.index;
        return ch;
    }

    public char peek() {
        try {
            return this.input.charAt(this.index);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw this.buildException("truncated input");
        }
    }

    public void unread() {
        if (this.index == 0) {
            throw new IllegalStateException();
        }
        --this.index;
    }

    public void expect(char ch) {
        if (this.read() != ch) {
            this.unread();
            throw this.buildException("expected `" + ch + "'");
        }
    }

    public void skipWhitespace() {
        while (this.index < this.input.length() && Character.isWhitespace(this.input.charAt(this.index))) {
            ++this.index;
        }
    }

    public ParseContext clone() {
        try {
            return (ParseContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public IllegalArgumentException buildException() {
        return this.buildException(null);
    }

    public IllegalArgumentException buildException(String message) {
        String text = "parse error ";
        String bogus = this.getInput();
        if (bogus.length() == 0) {
            text = text + "at end of input";
        } else {
            if (bogus.length() > 15) {
                bogus = bogus.substring(0, 12) + "...";
            }
            text = text + "starting with `" + bogus + "'";
        }
        if (message != null) {
            text = text + ": " + message;
        }
        return new IllegalArgumentException(text);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParseContext that = (ParseContext)obj;
        return this.input.equals(that.input) && this.index == that.index;
    }

    public int hashCode() {
        return this.input.hashCode() ^ this.index;
    }
}

