/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.dellroad.stuff.xml.EventWriterDelegate;

public abstract class AnnotatedXMLEventWriter
extends EventWriterDelegate {
    protected final XMLEventFactory xmlEventFactory = XMLEventFactory.newFactory();
    private final StringBuilder trailingSpace = new StringBuilder();
    private byte state;

    public AnnotatedXMLEventWriter(XMLEventWriter inner) {
        super(inner);
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (this.state) {
            case 0: {
                if (event.isStartElement()) {
                    this.state = (byte)(this.state + 1);
                }
                super.add(event);
                break;
            }
            case 1: {
                if (event.isNamespace() || event.isAttribute()) {
                    super.add(event);
                    break;
                }
                if (event.isCharacters() && event.asCharacters().isWhiteSpace()) {
                    this.trailingSpace.append(event.asCharacters().getData());
                    super.add(event);
                    break;
                }
                this.state = (byte)(this.state + 1);
                this.addAnnotationElement(this.getParent());
                if (this.trailingSpace.length() > 0) {
                    super.add(this.xmlEventFactory.createCharacters(this.trailingSpace.toString()));
                }
                super.add(event);
                break;
            }
            case 2: {
                super.add(event);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new XMLStreamException("null reader");
        }
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    protected String getTrailingSpace() {
        return this.trailingSpace.toString();
    }

    protected abstract void addAnnotationElement(XMLEventWriter var1) throws XMLStreamException;
}

