/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class StackXMLEventReader
extends EventReaderDelegate {
    private final ArrayList<StartElement> stack = new ArrayList();

    public StackXMLEventReader(XMLEventReader reader) {
        super(reader);
        if (reader == null) {
            throw new IllegalArgumentException("null reader");
        }
    }

    public StartElement getTopElement() {
        return !this.stack.isEmpty() ? this.stack.get(this.stack.size() - 1) : null;
    }

    public List<StartElement> getElementStack() {
        return new ArrayList<StartElement>(this.stack);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = super.getElementText();
        this.stack.remove(this.stack.size() - 1);
        return text;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return this.adjust(super.nextEvent());
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        return this.adjust(super.nextTag());
    }

    protected XMLEvent adjust(XMLEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.stack.add(event.asStartElement());
                break;
            }
            case 2: {
                this.stack.remove(this.stack.size() - 1);
                break;
            }
        }
        return event;
    }
}

