/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.string.StringEncoder;

public abstract class StreamWriterAction {
    protected StreamWriterAction() {
    }

    public abstract void apply(XMLStreamWriter var1) throws XMLStreamException;

    public static StreamWriterAction of(XMLStreamReader reader) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 1: {
                return new StartElementAction(reader);
            }
            case 2: {
                return new EndElementAction();
            }
            case 3: {
                return new PIAction(reader);
            }
            case 4: 
            case 6: {
                return new CharactersAction(reader);
            }
            case 5: {
                return new CommentAction(reader);
            }
            case 7: {
                return new StartDocumentAction(reader);
            }
            case 8: {
                return new EndDocumentAction();
            }
            case 9: {
                return new EntityRefAction(reader);
            }
            case 11: {
                return new DTDAction(reader);
            }
            case 12: {
                return new CDataAction(reader);
            }
            case 10: 
            case 13: {
                return new EmptyAction();
            }
            case 14: 
            case 15: {
                return new EmptyAction();
            }
        }
        throw new XMLStreamException("unknown event type " + reader.getEventType());
    }

    private static class EmptyAction
    extends StreamWriterAction {
        private EmptyAction() {
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
        }

        public String toString() {
            return "Empty";
        }
    }

    private static class EntityRefAction
    extends StreamWriterAction {
        private final String localName;

        EntityRefAction(XMLStreamReader reader) {
            this.localName = reader.getLocalName();
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEntityRef(this.localName);
        }

        public String toString() {
            return "EntityRef[\"" + this.localName + "\"]";
        }
    }

    private static class EndDocumentAction
    extends StreamWriterAction {
        private EndDocumentAction() {
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEndDocument();
            writer.flush();
        }

        public String toString() {
            return "EndDocument";
        }
    }

    private static class StartDocumentAction
    extends StreamWriterAction {
        protected final String encoding;
        protected final String version;

        StartDocumentAction(XMLStreamReader reader) {
            this.encoding = reader.getEncoding();
            this.version = reader.getVersion();
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartDocument(this.encoding, this.version);
        }

        public String toString() {
            return "StartDocument[encoding=\"" + this.encoding + "\",version=\"" + this.version + "\"]";
        }
    }

    private static class CDataAction
    extends CharactersAction {
        CDataAction(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeCData(this.text);
        }
    }

    private static class DTDAction
    extends CharactersAction {
        DTDAction(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeDTD(this.text);
        }
    }

    private static class CommentAction
    extends CharactersAction {
        CommentAction(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeComment(this.text);
        }
    }

    private static class CharactersAction
    extends StreamWriterAction {
        protected final String text;

        CharactersAction(XMLStreamReader reader) {
            this.text = reader.getText();
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeCharacters(this.text);
        }

        public String toString() {
            return this.getClass().getSimpleName().replaceAll("Action$", "") + "[text=" + StringEncoder.enquote(this.text) + "]";
        }
    }

    private static class PIAction
    extends StreamWriterAction {
        private final String target;
        private final String data;

        PIAction(XMLStreamReader reader) {
            this.target = reader.getPITarget();
            this.data = reader.getPIData();
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeProcessingInstruction(this.target, this.data);
        }

        public String toString() {
            return "PI[target=\"" + this.target + "\",data=\"" + this.data + "\"]";
        }
    }

    private static class EndElementAction
    extends StreamWriterAction {
        private EndElementAction() {
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEndElement();
        }

        public String toString() {
            return "EndElement";
        }
    }

    private static class StartElementAction
    extends StreamWriterAction {
        final String prefix;
        final String localName;
        final String namespaceURI;
        final NamespaceContext namespaceContext;
        final String[] nsPrefix;
        final String[] nsURI;
        final String[] attrPrefix;
        final String[] attrNamespace;
        final String[] attrLocalName;
        final String[] attrValue;

        StartElementAction(XMLStreamReader reader) {
            this.prefix = reader.getPrefix();
            this.localName = reader.getLocalName();
            this.namespaceURI = reader.getNamespaceURI();
            this.namespaceContext = reader.getNamespaceContext();
            int numNS = reader.getNamespaceCount();
            this.nsPrefix = new String[numNS];
            this.nsURI = new String[numNS];
            for (int i = 0; i < numNS; ++i) {
                this.nsPrefix[i] = reader.getNamespacePrefix(i);
                this.nsURI[i] = reader.getNamespaceURI(i);
            }
            int numAttrs = reader.getAttributeCount();
            this.attrPrefix = new String[numAttrs];
            this.attrNamespace = new String[numAttrs];
            this.attrLocalName = new String[numAttrs];
            this.attrValue = new String[numAttrs];
            for (int i = 0; i < numAttrs; ++i) {
                this.attrPrefix[i] = reader.getAttributePrefix(i);
                this.attrNamespace[i] = reader.getAttributeNamespace(i);
                this.attrLocalName[i] = reader.getAttributeLocalName(i);
                this.attrValue[i] = reader.getAttributeValue(i);
            }
        }

        @Override
        public void apply(XMLStreamWriter writer) throws XMLStreamException {
            int i;
            if (this.namespaceURI != null) {
                writer.writeStartElement(this.prefix, this.localName, this.namespaceURI);
            } else {
                writer.writeStartElement(this.localName);
            }
            writer.setNamespaceContext(this.namespaceContext);
            for (i = 0; i < this.nsPrefix.length; ++i) {
                writer.writeNamespace(this.nsPrefix[i], this.nsURI[i]);
            }
            for (i = 0; i < this.attrPrefix.length; ++i) {
                if (this.attrNamespace[i] != null) {
                    writer.writeAttribute(this.attrPrefix[i], this.attrNamespace[i], this.attrLocalName[i], this.attrValue[i]);
                    continue;
                }
                writer.writeAttribute(this.attrLocalName[i], this.attrValue[i]);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("StartElement[");
            buf.append("prefix=\"").append(this.prefix).append("\"");
            buf.append(",localName=\"").append(this.localName).append("\"");
            buf.append(",namespaceURI=\"").append(this.namespaceURI).append("\"");
            buf.append(",namespaceContext=\"").append(this.namespaceContext).append("\"");
            buf.append(",attrPrefix=").append(Arrays.asList(this.attrPrefix));
            buf.append(",attrNamespace=").append(Arrays.asList(this.attrNamespace));
            buf.append(",attrLocalName=").append(Arrays.asList(this.attrLocalName));
            buf.append(",attrValue=").append(Arrays.asList(this.attrValue));
            buf.append("]");
            return buf.toString();
        }
    }
}

