/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.app;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.dellroad.stuff.main.MainClass;
import org.jsimpledb.JSimpleDBFactory;
import org.jsimpledb.annotation.JFieldType;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.spring.JSimpleDBClassScanner;
import org.jsimpledb.spring.JSimpleDBFieldTypeScanner;

public abstract class AbstractMain
extends MainClass {
    private static final File DEMO_XML_FILE = new File("demo-database.xml");
    private static final File DEMO_SUBDIR = new File("demo-classes");
    protected int schemaVersion;
    protected HashSet<Class<?>> schemaClasses;
    protected HashSet<Class<? extends FieldType<?>>> fieldTypeClasses;
    protected boolean allowNewSchema;
    protected KVDatabase kvdb;
    protected String databaseDescription;
    protected boolean verbose;
    protected boolean readOnly;
    private final HashMap<KVImplementation, Object> kvConfigMap = new HashMap();
    private KVImplementation requiredAtomicKVStore;
    private KVImplementation requiredKVDatabase;
    private KVImplementation kvImplementation;

    public int parseOptions(ArrayDeque<String> params) {
        if (params.isEmpty() && DEMO_XML_FILE.exists() && DEMO_SUBDIR.exists()) {
            params.add("--xml");
            params.add(DEMO_XML_FILE.toString());
            params.add("--classpath");
            params.add(DEMO_SUBDIR.toString());
            params.add("--model-pkg");
            params.add("org.jsimpledb.demo");
            StringBuilder buf = new StringBuilder();
            for (String param : params) {
                buf.append(' ').append(param);
            }
            System.err.println(this.getName() + ": automatically configuring demo database using the following flags:\n " + buf);
        }
        KVImplementation[] i = params.iterator();
        while (i.hasNext()) {
            String param = i.next();
            if (!param.equals("-cp") && !param.equals("--classpath")) continue;
            i.remove();
            if (!i.hasNext()) {
                this.usageError();
            }
            if (!this.appendClasspath((String)i.next())) {
                return 1;
            }
            i.remove();
        }
        for (KVImplementation availableKVImplementation : KVImplementation.getImplementations()) {
            Object config;
            try {
                config = availableKVImplementation.parseCommandLineOptions(params);
            }
            catch (IllegalArgumentException e) {
                System.err.println(this.getName() + ": " + (e.getMessage() != null ? e.getMessage() : e));
                return 1;
            }
            if (config == null) continue;
            this.kvConfigMap.put(availableKVImplementation, config);
        }
        LinkedHashSet<String> modelPackages = new LinkedHashSet<String>();
        LinkedHashSet<String> typePackages = new LinkedHashSet<String>();
        while (!params.isEmpty() && params.peekFirst().startsWith("-")) {
            String option = params.removeFirst();
            if (option.equals("-h") || option.equals("--help")) {
                this.usageMessage();
                return 0;
            }
            if (option.equals("-ro") || option.equals("--read-only")) {
                this.readOnly = true;
                continue;
            }
            if (option.equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (option.equals("-v") || option.equals("--schema-version")) {
                String vstring;
                if (params.isEmpty()) {
                    this.usageError();
                }
                if ((vstring = params.removeFirst()).trim().equalsIgnoreCase("auto")) {
                    this.schemaVersion = -1;
                    continue;
                }
                try {
                    this.schemaVersion = Integer.parseInt(vstring);
                    if (this.schemaVersion >= -1) continue;
                    throw new IllegalArgumentException("schema version is < -1");
                }
                catch (Exception e) {
                    System.err.println(this.getName() + ": invalid schema version `" + vstring + "': " + e.getMessage());
                    return 1;
                }
            }
            if (option.equals("--model-pkg")) {
                if (params.isEmpty()) {
                    this.usageError();
                }
                modelPackages.add(params.removeFirst());
                continue;
            }
            if (option.equals("--type-pkg")) {
                if (params.isEmpty()) {
                    this.usageError();
                }
                typePackages.add(params.removeFirst());
                continue;
            }
            if (option.equals("-p") || option.equals("--pkg")) {
                if (params.isEmpty()) {
                    this.usageError();
                }
                String packageName = params.removeFirst();
                modelPackages.add(packageName);
                typePackages.add(packageName);
                continue;
            }
            if (option.equals("--new-schema")) {
                this.allowNewSchema = true;
                continue;
            }
            if (option.equals("--")) break;
            if (this.parseOption(option, params)) continue;
            System.err.println(this.getName() + ": unknown option `" + option + "'");
            this.usageError();
            return 1;
        }
        Iterator<KVImplementation> i2 = this.kvConfigMap.keySet().iterator();
        switch (this.kvConfigMap.size()) {
            case 0: {
                System.err.println(this.getName() + ": no key/value database specified; use one of `--arraydb', etc.");
                this.usageError();
                return 1;
            }
            case 1: {
                this.kvImplementation = i2.next();
                Object config = this.kvConfigMap.get(this.kvImplementation);
                if (!this.kvImplementation.requiresAtomicKVStore(config) && !this.kvImplementation.requiresKVDatabase(config)) break;
                System.err.println(this.getName() + ": " + this.kvImplementation.getDescription(config) + " requires the configuration of an underlying key/value technology; use one of `--arraydb', etc.");
                return 1;
            }
            case 2: {
                KVImplementation[] kvis = new KVImplementation[]{i2.next(), i2.next()};
                Object[] configs = new Object[]{this.kvConfigMap.get(kvis[0]), this.kvConfigMap.get(kvis[1])};
                if (kvis[0].requiresAtomicKVStore(configs[0]) || kvis[0].requiresKVDatabase(configs[0])) {
                    Collections.reverse(Arrays.asList(kvis));
                    Collections.reverse(Arrays.asList(configs));
                }
                if (kvis[0].requiresAtomicKVStore(configs[0]) || kvis[0].requiresKVDatabase(configs[0]) || !kvis[1].requiresAtomicKVStore(configs[1]) && !kvis[1].requiresKVDatabase(configs[1])) {
                    System.err.println(this.getName() + ": incompatible combination of " + kvis[0].getDescription(configs[0]) + " and " + kvis[1].getDescription(configs[1]));
                    return 1;
                }
                if (kvis[1].requiresAtomicKVStore(configs[1])) {
                    this.requiredAtomicKVStore = kvis[0];
                } else {
                    this.requiredKVDatabase = kvis[0];
                }
                this.kvImplementation = kvis[1];
                break;
            }
            default: {
                System.err.println(this.getName() + ": too many key/value store(s) specified");
                return 1;
            }
        }
        LinkedHashSet<String> emptyPackages = new LinkedHashSet<String>();
        emptyPackages.addAll(modelPackages);
        emptyPackages.addAll(typePackages);
        modelPackages.stream().filter(this::scanModelClasses).forEach(emptyPackages::remove);
        typePackages.stream().filter(this::scanTypeClasses).forEach(emptyPackages::remove);
        for (String packageName : emptyPackages) {
            boolean isModel = modelPackages.contains(packageName);
            boolean isType = typePackages.contains(packageName);
            if (isModel && isType) {
                this.log.warn("no Java model or custom FieldType classes found under package `" + packageName + "'");
                continue;
            }
            if (isModel) {
                this.log.warn("no Java model classes found under package `" + packageName + "'");
                continue;
            }
            this.log.warn("no custom FieldType classes found under package `" + packageName + "'");
        }
        return -1;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean isAllowNewSchema() {
        return this.allowNewSchema;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getDatabaseDescription() {
        return this.databaseDescription;
    }

    public JSimpleDBFactory getJSimpleDBFactory(Database db) {
        return new JSimpleDBFactory().setModelClasses(this.schemaClasses).setSchemaVersion(this.schemaVersion).setDatabase(db);
    }

    protected boolean parseOption(String option, ArrayDeque<String> params) {
        return false;
    }

    protected boolean appendClasspath(String path) {
        this.log.trace("adding classpath `" + path + "' to system classpath");
        try {
            Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
            for (String file : path.split(System.getProperty("path.separator", ":"))) {
                if (file.length() == 0) continue;
                addURLMethod.invoke((Object)ClassLoader.getSystemClassLoader(), new File(file).toURI().toURL());
                this.log.trace("added path component `" + file + "' to system classpath");
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("can't append `" + path + " to classpath: " + e, (Throwable)e);
            return false;
        }
    }

    private boolean scanModelClasses(String pkgname) {
        if (this.schemaClasses == null) {
            this.schemaClasses = new HashSet();
        }
        boolean[] foundAny = new boolean[1];
        new JSimpleDBClassScanner().scanForClasses(pkgname.split("[\\s,]")).stream().peek(name -> this.log.debug("loading Java model class " + name)).map(this::loadClass).peek(cl -> {
            foundAny[0] = true;
        }).forEach(this.schemaClasses::add);
        return foundAny[0];
    }

    private boolean scanTypeClasses(String pkgname) {
        if (this.fieldTypeClasses == null) {
            this.fieldTypeClasses = new HashSet();
        }
        boolean[] foundAny = new boolean[1];
        new JSimpleDBFieldTypeScanner().scanForClasses(pkgname.split("[\\s,]")).stream().peek(name -> this.log.debug("loading custom FieldType class " + name)).map(this::loadClass).peek(cl -> {
            foundAny[0] = true;
        }).map(cl -> {
            try {
                return cl.asSubclass(FieldType.class);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("invalid @" + JFieldType.class.getSimpleName() + " annotation on " + cl + ": type is not a subclass of " + FieldType.class);
            }
        }).forEach(this.fieldTypeClasses::add);
        return foundAny[0];
    }

    private boolean createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println(this.getName() + ": could not create directory `" + dir + "'");
            return false;
        }
        if (!dir.isDirectory()) {
            System.err.println(this.getName() + ": file `" + dir + "' is not a directory");
            return false;
        }
        return true;
    }

    protected Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to load class `" + className + "'", e);
        }
    }

    protected Database startupKVDatabase() {
        Object config = this.kvConfigMap.get(this.kvImplementation);
        AtomicKVStore nestedKVS = this.requiredAtomicKVStore != null ? this.requiredAtomicKVStore.createAtomicKVStore(this.kvConfigMap.get(this.requiredAtomicKVStore)) : null;
        KVDatabase nestedKV = this.requiredKVDatabase != null ? this.requiredKVDatabase.createKVDatabase(this.kvConfigMap.get(this.requiredAtomicKVStore), null, null) : null;
        this.kvdb = this.kvImplementation.createKVDatabase(config, nestedKV, nestedKVS);
        this.databaseDescription = this.kvImplementation.getDescription(config);
        this.log.debug("using database: " + this.databaseDescription);
        this.kvdb.start();
        Database db = new Database(this.kvdb);
        if (this.fieldTypeClasses != null) {
            db.getFieldTypeRegistry().addClasses(this.fieldTypeClasses);
        }
        return db;
    }

    protected void shutdownKVDatabase() {
        this.kvdb.stop();
    }

    protected abstract String getName();

    protected void outputFlags(String[][] subclassOpts) {
        KVImplementation[] kvs;
        ArrayList optionList = new ArrayList();
        optionList.addAll(Arrays.asList({"--classpath, -cp path", "Append to the classpath (useful with `java -jar ...')"}, {"--read-only, -ro", "Disallow database modifications"}, {"--new-schema", "Allow recording of a new database schema version"}, {"--schema-version, -v num", "Specify schema version (default highest recorded; `auto' to auto-generate)"}, {"--model-pkg package", "Scan for @JSimpleClass model classes under Java package (=> JSimpleDB mode)"}, {"--type-pkg package", "Scan for @JFieldType types under Java package to register custom types"}, {"--pkg, -p package", "Equivalent to `--model-pkg package --type-pkg package'"}, {"--help, -h", "Show this help message"}, {"--verbose", "Show verbose error messages"}));
        for (KVImplementation kv : kvs = KVImplementation.getImplementations()) {
            optionList.addAll(Arrays.asList(kv.getCommandLineOptions()));
        }
        if (subclassOpts != null) {
            optionList.addAll(Arrays.asList(subclassOpts));
        }
        Collections.sort(optionList, (opt1, opt2) -> opt1[0].compareTo(opt2[0]));
        int width = 0;
        for (String[] opt : optionList) {
            width = Math.max(width, opt[0].length());
        }
        for (String[] opt : optionList) {
            System.err.println(String.format("  %-" + width + "s  %s", opt[0], opt[1]));
        }
        for (KVImplementation kv : kvs) {
            String usageText = kv.getUsageText();
            if (usageText == null) continue;
            System.err.println(usageText.trim());
        }
    }
}

