/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Key;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.KeyRange;
import java.util.Objects;

public final class KeyRange {
    private final Key start;
    private final Endpoint startType;
    private final Key end;
    private final Endpoint endType;

    private KeyRange(Key start, Endpoint startType, Key end, Endpoint endType) {
        this.start = start;
        this.startType = startType;
        this.end = end;
        this.endType = endType;
    }

    public static KeyRange closedOpen(Key start, Key end) {
        return new KeyRange((Key)Preconditions.checkNotNull((Object)start), Endpoint.CLOSED, (Key)Preconditions.checkNotNull((Object)end), Endpoint.OPEN);
    }

    public static KeyRange closedClosed(Key start, Key end) {
        return new KeyRange((Key)Preconditions.checkNotNull((Object)start), Endpoint.CLOSED, (Key)Preconditions.checkNotNull((Object)end), Endpoint.CLOSED);
    }

    public static KeyRange openOpen(Key start, Key end) {
        return new KeyRange((Key)Preconditions.checkNotNull((Object)start), Endpoint.OPEN, (Key)Preconditions.checkNotNull((Object)end), Endpoint.OPEN);
    }

    public static KeyRange openClosed(Key start, Key end) {
        return new KeyRange((Key)Preconditions.checkNotNull((Object)start), Endpoint.OPEN, (Key)Preconditions.checkNotNull((Object)end), Endpoint.CLOSED);
    }

    public static KeyRange prefix(Key prefix) {
        return KeyRange.closedClosed(prefix, prefix);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Key getStart() {
        return this.start;
    }

    public Endpoint getStartType() {
        return this.startType;
    }

    public Key getEnd() {
        return this.end;
    }

    public Endpoint geEndType() {
        return this.endType;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    void toString(StringBuilder b) {
        b.append(this.startType == Endpoint.CLOSED ? (char)'[' : '(');
        this.start.toString(b);
        b.append(',');
        this.end.toString(b);
        b.append(this.endType == Endpoint.CLOSED ? (char)']' : ')');
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyRange that = (KeyRange)o;
        return this.startType == that.startType && this.endType == that.endType && this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.startType, this.end, this.endType});
    }

    com.google.spanner.v1.KeyRange toProto() {
        KeyRange.Builder builder = com.google.spanner.v1.KeyRange.newBuilder();
        if (this.startType == Endpoint.CLOSED) {
            builder.setStartClosed(this.start.toProto());
        } else {
            builder.setStartOpen(this.start.toProto());
        }
        if (this.endType == Endpoint.CLOSED) {
            builder.setEndClosed(this.end.toProto());
        } else {
            builder.setEndOpen(this.end.toProto());
        }
        return builder.build();
    }

    public static class Builder {
        private Key start;
        private Endpoint startType = Endpoint.CLOSED;
        private Key end;
        private Endpoint endType = Endpoint.OPEN;

        private Builder() {
        }

        private Builder(KeyRange r) {
            this.start = r.start;
            this.startType = r.startType;
            this.end = r.end;
            this.endType = r.endType;
        }

        public Builder setStart(Key key) {
            this.start = (Key)Preconditions.checkNotNull((Object)key);
            return this;
        }

        public Builder setStartType(Endpoint type) {
            this.startType = (Endpoint)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public Builder setEnd(Key key) {
            this.end = (Key)Preconditions.checkNotNull((Object)key);
            return this;
        }

        public Builder setEndType(Endpoint type) {
            this.endType = (Endpoint)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public KeyRange build() {
            Preconditions.checkState((this.start != null ? 1 : 0) != 0, (Object)"Missing required call to start(Key)");
            Preconditions.checkState((this.end != null ? 1 : 0) != 0, (Object)"Missing required call to end(Key)");
            return new KeyRange(this.start, this.startType, this.end, this.endType);
        }
    }

    public static enum Endpoint {
        CLOSED,
        OPEN;

    }
}

