/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.KeySet;
import java.util.Objects;

public final class KeySet {
    private final boolean all;
    private final ImmutableList<Key> keys;
    private final ImmutableList<KeyRange> ranges;

    private KeySet(boolean all, ImmutableList<Key> keys, ImmutableList<KeyRange> ranges) {
        this.all = all;
        this.keys = keys;
        this.ranges = ranges;
    }

    public static KeySet singleKey(Key key) {
        return new KeySet(false, (ImmutableList<Key>)ImmutableList.of((Object)key), (ImmutableList<KeyRange>)ImmutableList.of());
    }

    public static KeySet range(KeyRange range) {
        return new KeySet(false, (ImmutableList<Key>)ImmutableList.of(), (ImmutableList<KeyRange>)ImmutableList.of((Object)range));
    }

    public static KeySet prefixRange(Key prefix) {
        return KeySet.range(KeyRange.prefix(prefix));
    }

    public static KeySet all() {
        return new KeySet(true, (ImmutableList<Key>)ImmutableList.of(), (ImmutableList<KeyRange>)ImmutableList.of());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Iterable<Key> getKeys() {
        return this.keys;
    }

    public Iterable<KeyRange> getRanges() {
        return this.ranges;
    }

    public boolean isAll() {
        return this.all;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    void toString(StringBuilder b) {
        b.append('{');
        int size = 0;
        if (this.all) {
            ++size;
            b.append("<all>");
        }
        for (Key key : this.keys) {
            if (size++ > 0) {
                b.append(',');
            }
            key.toString(b);
        }
        for (KeyRange range : this.ranges) {
            if (size++ > 0) {
                b.append(',');
            }
            range.toString(b);
        }
        b.append('}');
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeySet that = (KeySet)o;
        return this.all == that.all && this.keys.equals(that.keys) && this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.keys, this.ranges);
    }

    void appendToProto(KeySet.Builder proto) {
        for (Key key : this.keys) {
            proto.addKeys(key.toProto());
        }
        for (KeyRange range : this.ranges) {
            proto.addRanges(range.toProto());
        }
        if (this.all) {
            proto.setAll(true);
        }
    }

    public static class Builder {
        private boolean all;
        private ImmutableList.Builder<Key> keys;
        private ImmutableList.Builder<KeyRange> ranges;

        private Builder() {
        }

        private Builder(KeySet set) {
            this.all = set.all;
            if (!set.keys.isEmpty()) {
                this.keys = ImmutableList.builder().addAll((Iterable)set.keys);
            }
            if (!set.ranges.isEmpty()) {
                this.ranges = ImmutableList.builder().addAll((Iterable)set.ranges);
            }
        }

        public Builder addKey(Key key) {
            if (this.keys == null) {
                this.keys = ImmutableList.builder();
            }
            this.keys.add((Object)key);
            return this;
        }

        public Builder addRange(KeyRange range) {
            if (this.ranges == null) {
                this.ranges = ImmutableList.builder();
            }
            this.ranges.add((Object)range);
            return this;
        }

        public Builder setAll() {
            this.all = true;
            return this;
        }

        public KeySet build() {
            return new KeySet(this.all, this.keys != null ? this.keys.build() : ImmutableList.of(), this.ranges != null ? this.ranges.build() : ImmutableList.of());
        }
    }
}

