/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.spanner.v1.TransactionOptions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class TimestampBound {
    private static final TimestampBound STRONG_BOUND = new TimestampBound(Mode.STRONG, null, null);
    private static final TransactionOptions.ReadOnly STRONG_PROTO = TransactionOptions.ReadOnly.newBuilder().setStrong(true).build();
    private final Mode mode;
    private final Timestamp timestamp;
    private final Duration staleness;

    private TimestampBound(Mode mode, Timestamp timestamp, Duration staleness) {
        this.mode = mode;
        this.timestamp = timestamp;
        this.staleness = staleness;
    }

    public static TimestampBound strong() {
        return STRONG_BOUND;
    }

    public static TimestampBound ofReadTimestamp(Timestamp timestamp) {
        return new TimestampBound(Mode.READ_TIMESTAMP, (Timestamp)Preconditions.checkNotNull((Object)timestamp), null);
    }

    public static TimestampBound ofMinReadTimestamp(Timestamp timestamp) {
        return new TimestampBound(Mode.MIN_READ_TIMESTAMP, (Timestamp)Preconditions.checkNotNull((Object)timestamp), null);
    }

    public static TimestampBound ofExactStaleness(long num, TimeUnit units) {
        TimestampBound.checkStaleness(num);
        return new TimestampBound(Mode.EXACT_STALENESS, null, TimestampBound.createDuration(num, units));
    }

    public static TimestampBound ofMaxStaleness(long num, TimeUnit units) {
        TimestampBound.checkStaleness(num);
        return new TimestampBound(Mode.MAX_STALENESS, null, TimestampBound.createDuration(num, units));
    }

    public Mode getMode() {
        return this.mode;
    }

    public Timestamp getReadTimestamp() {
        this.checkMode(Mode.READ_TIMESTAMP);
        return this.timestamp;
    }

    public Timestamp getMinReadTimestamp() {
        this.checkMode(Mode.MIN_READ_TIMESTAMP);
        return this.timestamp;
    }

    public long getExactStaleness(TimeUnit units) {
        this.checkMode(Mode.EXACT_STALENESS);
        return TimestampBound.durationToUnits(this.staleness, units);
    }

    public long getMaxStaleness(TimeUnit units) {
        this.checkMode(Mode.MAX_STALENESS);
        return TimestampBound.durationToUnits(this.staleness, units);
    }

    StringBuilder toString(StringBuilder b) {
        switch (this.mode) {
            case STRONG: {
                return b.append("strong");
            }
            case READ_TIMESTAMP: {
                return b.append("exact_timestamp: ").append(this.timestamp.toString());
            }
            case MIN_READ_TIMESTAMP: {
                return b.append("min_read_timestamp: ").append(this.timestamp.toString());
            }
            case EXACT_STALENESS: {
                return b.append("exact_staleness: ").append(Durations.toString((Duration)this.staleness));
            }
            case MAX_STALENESS: {
                return b.append("max_staleness: ").append(Durations.toString((Duration)this.staleness));
            }
        }
        throw new AssertionError((Object)("Unexpected mode: " + (Object)((Object)this.mode)));
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampBound that = (TimestampBound)o;
        return this.mode == that.mode && Objects.equals(this.staleness, that.staleness) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.timestamp, this.staleness});
    }

    TransactionOptions.ReadOnly toProto() {
        if (this.mode == Mode.STRONG) {
            return STRONG_PROTO;
        }
        TransactionOptions.ReadOnly.Builder builder = TransactionOptions.ReadOnly.newBuilder();
        this.applyToBuilder(builder);
        return builder.build();
    }

    TransactionOptions.ReadOnly.Builder applyToBuilder(TransactionOptions.ReadOnly.Builder builder) {
        switch (this.mode) {
            case STRONG: {
                return builder.setStrong(true);
            }
            case READ_TIMESTAMP: {
                return builder.setReadTimestamp(this.timestamp.toProto());
            }
            case MIN_READ_TIMESTAMP: {
                return builder.setMinReadTimestamp(this.timestamp.toProto());
            }
            case EXACT_STALENESS: {
                return builder.setExactStaleness(this.staleness);
            }
            case MAX_STALENESS: {
                return builder.setMaxStaleness(this.staleness);
            }
        }
        throw new AssertionError((Object)("Unexpected mode: " + (Object)((Object)this.mode)));
    }

    private static void checkStaleness(double num) {
        Preconditions.checkArgument((num >= 0.0 ? 1 : 0) != 0, (Object)"Staleness cannot be negative");
    }

    private void checkMode(Mode requiredMode) {
        Preconditions.checkState((this.mode == requiredMode ? 1 : 0) != 0, (String)"Invalid call for mode %s", (Object[])new Object[]{this.mode});
    }

    private static Duration createDuration(long num, TimeUnit units) {
        switch (units) {
            case NANOSECONDS: {
                return Durations.fromNanos((long)num);
            }
            case MICROSECONDS: {
                return Durations.fromMicros((long)num);
            }
        }
        return Durations.fromMillis((long)units.toMillis(num));
    }

    private static long durationToUnits(Duration duration, TimeUnit units) {
        switch (units) {
            case NANOSECONDS: {
                return Durations.toNanos((Duration)duration);
            }
            case MICROSECONDS: {
                return Durations.toMicros((Duration)duration);
            }
        }
        return units.convert(Durations.toMillis((Duration)duration), TimeUnit.MILLISECONDS);
    }

    public static enum Mode {
        STRONG,
        READ_TIMESTAMP,
        MIN_READ_TIMESTAMP,
        EXACT_STALENESS,
        MAX_STALENESS;

    }
}

