/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import java.util.Arrays;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.Index;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.schema.SimpleSchemaField;
import org.jsimpledb.util.ByteReader;

class CompositeIndex
extends Index {
    protected final int[] fieldStorageIds;
    protected final FieldType<?>[] fieldTypes;

    CompositeIndex(JsckInfo info, int schemaVersion, SchemaObjectType objectType, SchemaCompositeIndex index) {
        super(info, index.getStorageId());
        this.fieldStorageIds = index.getIndexedFields().stream().mapToInt(Integer::intValue).toArray();
        this.fieldTypes = new FieldType[this.fieldStorageIds.length];
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            SimpleSchemaField field = (SimpleSchemaField)objectType.getSchemaFields().get(this.fieldStorageIds[i]);
            this.fieldTypes[i] = this.info.findFieldType(schemaVersion, field).genericizeForIndex();
        }
    }

    @Override
    public boolean isCompatible(Storage that) {
        if (!super.isCompatible(that)) {
            return false;
        }
        if (!Arrays.equals(this.fieldStorageIds, ((CompositeIndex)that).fieldStorageIds)) {
            return false;
        }
        return Arrays.equals(this.fieldTypes, ((CompositeIndex)that).fieldTypes);
    }

    @Override
    protected void validateIndexEntryContent(JsckInfo info, ByteReader reader) {
        byte[][] values = new byte[this.fieldTypes.length][];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.validateEncodedBytes(reader, this.fieldTypes[i]);
        }
        ObjId id = (ObjId)this.validateEncodedValue(reader, FieldTypeRegistry.OBJ_ID);
        this.validateEOF(reader);
        for (int i = 0; i < values.length; ++i) {
            this.validateSimpleObjectField(info, id, this.fieldStorageIds[i], this.fieldTypes[i], values[i]);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("composite index on ");
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("simple field #" + this.fieldStorageIds[i] + " having " + this.fieldTypes[i]);
        }
        return buf.toString();
    }
}

