/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.Index;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ParseContext;

public abstract class Issue {
    private static final int HEX_STRING_LIMIT = 100;
    private final String description;
    private final byte[] key;
    private final byte[] oldValue;
    private final byte[] newValue;
    private String detail;

    protected Issue(String description, byte[] key, byte[] oldValue, byte[] newValue) {
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"null description");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((!Arrays.equals(oldValue, newValue) || oldValue == null ? 1 : 0) != 0, (Object)"newValue = oldValue");
        this.description = description;
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public void apply(KVStore kvstore) {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        if (this.newValue != null) {
            kvstore.put(this.key, this.newValue);
        } else {
            kvstore.remove(this.key);
        }
    }

    public Issue setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public Issue setDetail(ObjId id, String detail) {
        return this.setDetail("for object " + id + ": " + detail);
    }

    public Issue setDetail(ObjId id, SchemaField field, String detail) {
        return this.setDetail("for object " + id + " " + field + ": " + detail);
    }

    public Issue setDetail(ObjId id, SchemaCompositeIndex index, String detail) {
        return this.setDetail("for object " + id + " " + index + ": " + detail);
    }

    public Issue setDetail(Index index, String detail) {
        return this.setDetail("for " + index + ": " + detail);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.description).append(": key [").append(ParseContext.truncate((String)ByteUtil.toString((byte[])this.key), (int)100)).append(']');
        if (this.oldValue != null && this.newValue != null) {
            buf.append(": incorrect value [").append(ParseContext.truncate((String)ByteUtil.toString((byte[])this.oldValue), (int)100)).append("]; corrected value [").append(ParseContext.truncate((String)ByteUtil.toString((byte[])this.newValue), (int)100)).append(']');
        } else if (this.oldValue != null) {
            buf.append(", value [").append(ParseContext.truncate((String)ByteUtil.toString((byte[])this.oldValue), (int)100)).append(']');
        } else if (this.newValue != null && this.newValue.length > 0) {
            buf.append(", corrected value [").append(ParseContext.truncate((String)ByteUtil.toString((byte[])this.newValue), (int)100)).append(']');
        }
        if (this.detail != null) {
            buf.append(": ").append(this.detail);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Issue that = (Issue)obj;
        return Arrays.equals(this.key, that.key) && Arrays.equals(this.oldValue, that.oldValue) && Arrays.equals(this.newValue, that.newValue) && Objects.equals(this.description, that.description) && Objects.equals(this.detail, that.detail);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.oldValue) ^ Arrays.hashCode(this.newValue) ^ Objects.hashCode(this.description) ^ Objects.hashCode(this.detail);
    }
}

