/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import java.util.Arrays;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.CollectionElementIndex;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.ListSchemaField;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

class ListElementIndex
extends CollectionElementIndex {
    ListElementIndex(JsckInfo info, int schemaVersion, ListSchemaField field) {
        super(info, schemaVersion, (CollectionSchemaField)field, "list");
    }

    @Override
    protected void validateIndexEntrySuffix(JsckInfo info, ByteReader reader, byte[] indexValue, ObjId id) {
        int listIndex = (Integer)this.validateEncodedValue(reader, FieldTypeRegistry.UNSIGNED_INT);
        this.validateEOF(reader);
        if (info.getConfig().isRepair()) {
            ByteWriter writer = this.buildFieldKey(id, this.parentStorageId);
            UnsignedIntEncoder.write((ByteWriter)writer, (int)listIndex);
            byte[] key = writer.getBytes();
            byte[] actualValue = info.getKVStore().get(key);
            if (actualValue == null) {
                throw new IllegalArgumentException("object " + id + " list field #" + this.parentStorageId + " with element " + this.type + " does not contain value " + Jsck.ds(indexValue) + " at index " + listIndex);
            }
            if (!Arrays.equals(actualValue, indexValue)) {
                throw new IllegalArgumentException("object " + id + " list field #" + this.parentStorageId + " with element " + this.type + "  contains value " + Jsck.ds(actualValue) + " != " + Jsck.ds(indexValue) + " at index " + listIndex);
            }
        }
    }
}

