/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.ComplexFieldIndex;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.schema.ComplexSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

class MapKeyIndex
extends ComplexFieldIndex {
    MapKeyIndex(JsckInfo info, int schemaVersion, MapSchemaField field) {
        super(info, schemaVersion, (ComplexSchemaField)field, field.getKeyField(), "map", "key");
    }

    @Override
    protected void validateIndexEntrySuffix(JsckInfo info, ByteReader reader, byte[] indexKeyValue, ObjId id) {
        this.validateEOF(reader);
        if (info.getConfig().isRepair()) {
            ByteWriter writer = this.buildFieldKey(id, this.parentStorageId);
            writer.write(indexKeyValue);
            byte[] key = writer.getBytes();
            byte[] actualValue = info.getKVStore().get(key);
            if (actualValue == null) {
                throw new IllegalArgumentException("object " + id + " map field #" + this.parentStorageId + " with key " + this.type + " does not contain key " + Jsck.ds(indexKeyValue));
            }
        }
    }
}

