/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import java.util.Arrays;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.ComplexFieldIndex;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.schema.ComplexSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

class MapValueIndex
extends ComplexFieldIndex {
    protected final FieldType<?> keyType;

    MapValueIndex(JsckInfo info, int schemaVersion, MapSchemaField field) {
        super(info, schemaVersion, (ComplexSchemaField)field, field.getValueField(), "map", "value");
        this.keyType = this.info.findFieldType(schemaVersion, field.getKeyField()).genericizeForIndex();
    }

    @Override
    public boolean isCompatible(Storage that) {
        if (!super.isCompatible(that)) {
            return false;
        }
        return this.keyType.equals(((MapValueIndex)that).keyType);
    }

    @Override
    protected void validateIndexEntrySuffix(JsckInfo info, ByteReader reader, byte[] indexValue, ObjId id) {
        byte[] indexKeyValue = this.validateEncodedBytes(reader, this.keyType);
        this.validateEOF(reader);
        if (info.getConfig().isRepair()) {
            ByteWriter writer = this.buildFieldKey(id, this.parentStorageId);
            writer.write(indexKeyValue);
            byte[] key = writer.getBytes();
            byte[] actualValue = info.getKVStore().get(key);
            if (actualValue == null) {
                throw new IllegalArgumentException("object " + id + " map field #" + this.parentStorageId + " with key " + this.keyType + " does not contain key " + Jsck.ds(indexKeyValue));
            }
            if (!Arrays.equals(actualValue, indexValue)) {
                throw new IllegalArgumentException("object " + id + " map field #" + this.parentStorageId + " with key " + this.keyType + "  contains value " + Jsck.ds(actualValue) + " != " + Jsck.ds(indexValue) + " under key " + Jsck.ds(indexKeyValue));
            }
        }
    }
}

