/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

abstract class Storage {
    protected final JsckInfo info;
    protected final int storageId;
    private int schemaVersion;

    protected Storage(JsckInfo info, int storageId) {
        Preconditions.checkArgument((info != null ? 1 : 0) != 0, (Object)"null info");
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"non-positive storageId");
        this.info = info;
        this.storageId = storageId;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public KeyRange getKeyRange() {
        return KeyRange.forPrefix((byte[])UnsignedIntEncoder.encode((int)this.storageId));
    }

    protected void validateObjectExists(JsckInfo info, ByteReader reader, ObjId id) {
        if (info.getConfig().isRepair() && info.getKVStore().get(id.getBytes()) == null) {
            throw new IllegalArgumentException("object with " + id + " does not exist");
        }
    }

    protected <T> byte[] validateEncodedBytes(ByteReader reader, FieldType<T> type) {
        Object value;
        int off = reader.getOffset();
        try {
            value = type.read(reader);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("can't decode value of " + type + " because value is truncated");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("can't decode value of " + type + ": " + e.getMessage());
        }
        int len = reader.getOffset() - off;
        byte[] bytes = reader.getBytes(off, len);
        ByteWriter writer = new ByteWriter(bytes.length);
        try {
            type.write(writer, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("decoding then re-encoding value " + Jsck.ds(bytes) + " (" + value + ") using " + type + " throws " + e, e);
        }
        byte[] bytes2 = writer.getBytes();
        if (!Arrays.equals(bytes2, bytes)) {
            throw new IllegalArgumentException("decoding then re-encoding value " + Jsck.ds(bytes) + " (" + value + ") using " + type + " results in a different value " + Jsck.ds(bytes2));
        }
        return bytes;
    }

    protected <T> T validateEncodedValue(ByteReader reader, FieldType<T> type) {
        return (T)type.read(new ByteReader(this.validateEncodedBytes(reader, type)));
    }

    protected void validateEOF(ByteReader reader) {
        if (reader.remain() > 0) {
            throw new IllegalArgumentException("value contains extra trailing garbage " + Jsck.ds(reader.getBytes(reader.getOffset())));
        }
    }

    protected ByteWriter buildFieldKey(ObjId id, int storageId) {
        ByteWriter writer = new ByteWriter();
        id.writeTo(writer);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        return writer;
    }

    public abstract String toString();

    public boolean isCompatible(Storage that) {
        if (this.storageId != that.storageId) {
            return false;
        }
        return this.getClass() == that.getClass();
    }
}

