/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck.cmd;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsimpledb.Session;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckConfig;
import org.jsimpledb.jsck.JsckLogger;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.util.ParseContext;

public class JsckCommand
extends AbstractCommand {
    public JsckCommand() {
        super("jsck -repair:repair -verbose:verbose -weak:weak -limit:limit:int -gc:gc -kv:kv:expr -force-schemas:schema-map:expr -force-format-version:format-version:int -registry:registry:expr");
    }

    public String getHelpSummary() {
        return "Check key/value database for inconsistencies and optionally repair them";
    }

    public String getHelpDetail() {
        return "Options:\n   -repair\n       In addition to detecting issues, attempt to repair them.\n   -limit\n       Stop after encountering `limit' issues.\n   -gc\n       Garbage collect unused schema versions at the end of inspection.\n   -kv\n       Specify a different KVStore to check (by default, the current transaction is checked).\n   -registry\n       Specify a custom field type registry. If this flag is not given, in JSimpleDB and Core API modes,\n       the configured registry will be used; in key/value database CLI mode, a default instances is used.\n       The parameter must be a Java expression returning a FieldTypeRegistry.\n   -force-schemas\n       Forcibly override schema versions. The parameter must be a Java expression returning a\n       Map<Integer, SchemaModel>. WARNING: only use this if you know what you are doing.\n       This flag is ignored without `-repair'.\n   -force-format-version\n       Forcibly override format version. WARNING: only use this if you know what you are doing.\n       This flag is ignored without `-repair'.\n   -verbose\n       Increase logging verbosity to show a high level of detail.\n   -weak\n       For certain key/value stores, use weaker consistency to reduce the chance of conflicts.\n       This flag is ignored if used with `-repair'.\n";
    }

    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    public CliSession.Action getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        Integer limit;
        JsckConfig config = new JsckConfig();
        boolean verbose = params.containsKey("verbose");
        config.setGarbageCollectSchemas(params.containsKey("gc"));
        config.setRepair(params.containsKey("repair"));
        boolean weak = params.containsKey("weak");
        Integer formatVersion = (Integer)params.get("format-version");
        if (formatVersion != null) {
            config.setForceFormatVersion(formatVersion);
        }
        if ((limit = (Integer)params.get("limit")) != null) {
            config.setMaxIssues(limit.intValue());
        }
        if (weak && (config.isGarbageCollectSchemas() || config.isRepair())) {
            throw new RuntimeException("`-weak' flag requires read-only transaction (incompatible with `-gc' and `-repair')");
        }
        return new JsckAction(config, (Node)params.get("kv"), (Node)params.get("registry"), (Node)params.get("schema-map"), verbose, weak);
    }

    private class JsckAction
    implements CliSession.Action,
    Session.TransactionalAction,
    Session.HasTransactionOptions {
        private final JsckConfig config;
        private final Node kvNode;
        private final Node registryNode;
        private final Node schemasNode;
        private final boolean verbose;
        private final boolean weak;

        JsckAction(JsckConfig config, Node kvNode, Node registryNode, Node schemasNode, boolean verbose, boolean weak) {
            this.config = config;
            this.kvNode = kvNode;
            this.registryNode = registryNode;
            this.schemasNode = schemasNode;
            this.verbose = verbose;
            this.weak = weak;
        }

        public void run(CliSession session) throws Exception {
            KVTransaction kv;
            Object object = kv = this.kvNode != null ? (KVStore)JsckCommand.this.getExprParam(session, this.kvNode, "kv", KVStore.class) : session.getKVTransaction();
            if (this.registryNode != null) {
                this.config.setFieldTypeRegistry((FieldTypeRegistry)JsckCommand.this.getExprParam(session, this.registryNode, "registry", FieldTypeRegistry.class));
            } else if (session.getDatabase() != null) {
                this.config.setFieldTypeRegistry(session.getDatabase().getFieldTypeRegistry());
            }
            if (this.schemasNode != null) {
                this.config.setForceSchemaVersions((Map)JsckCommand.this.getExprParam(session, this.schemasNode, "force-schemas", obj -> {
                    if (!(obj instanceof Map)) {
                        throw new IllegalArgumentException("must be a Map<Integer, SchemaModel>");
                    }
                    Map map = (Map)obj;
                    HashMap<Integer, SchemaModel> versionMap = new HashMap<Integer, SchemaModel>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof Integer)) {
                            throw new IllegalArgumentException("must be a Map<Integer, SchemaModel>; found key " + entry.getKey());
                        }
                        if (entry.getValue() != null && !(entry.getValue() instanceof SchemaModel)) {
                            throw new IllegalArgumentException("must be a Map<Integer, SchemaModel>; found value " + entry.getValue());
                        }
                        versionMap.put((Integer)entry.getKey(), (SchemaModel)entry.getValue());
                    }
                    return versionMap;
                }));
            }
            final PrintWriter writer = session.getWriter();
            this.config.setJsckLogger(new JsckLogger(){

                @Override
                public boolean isDetailEnabled() {
                    return JsckAction.this.verbose;
                }

                @Override
                public void info(String message) {
                    writer.println("jsck: " + message);
                }

                @Override
                public void detail(String message) {
                    if (JsckAction.this.verbose) {
                        writer.println("jsck: " + message);
                    }
                }
            });
            Jsck jsck = new Jsck(this.config);
            AtomicInteger count = new AtomicInteger();
            long numHandled = jsck.check((KVStore)kv, issue -> writer.println(String.format("[%05d] %s%s", count.incrementAndGet(), issue, this.config.isRepair() ? " [FIXED]" : "")));
            writer.println("jsck: " + (this.config.isRepair() ? "repaired" : "found") + " " + numHandled + " issue(s)");
        }

        public Map<String, ?> getTransactionOptions() {
            return this.weak && !this.config.isRepair() ? Collections.singletonMap("consistency", "EVENTUAL") : null;
        }
    }
}

