/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class ServletPathExtensionContentNegotiationStrategy
extends PathExtensionContentNegotiationStrategy {
    private final ServletContext servletContext;

    public ServletPathExtensionContentNegotiationStrategy(ServletContext servletContext, Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        Assert.notNull((Object)servletContext, (String)"ServletContext is required");
        this.servletContext = servletContext;
    }

    public ServletPathExtensionContentNegotiationStrategy(ServletContext context) {
        this(context, null);
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) throws HttpMediaTypeNotAcceptableException {
        MediaType superMediaType;
        String mimeType;
        MediaType mediaType = null;
        if (this.servletContext != null && StringUtils.hasText((String)(mimeType = this.servletContext.getMimeType("file." + extension)))) {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        if ((mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) && (superMediaType = super.handleNoMatch(webRequest, extension)) != null) {
            mediaType = superMediaType;
        }
        return mediaType;
    }

    @Override
    public MediaType getMediaTypeForResource(Resource resource) {
        MediaType superMediaType;
        String mimeType;
        MediaType mediaType = null;
        if (this.servletContext != null && StringUtils.hasText((String)(mimeType = this.servletContext.getMimeType(resource.getFilename())))) {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        if ((mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) && (superMediaType = super.getMediaTypeForResource(resource)) != null) {
            mediaType = superMediaType;
        }
        return mediaType;
    }
}

