/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.dellroad.stuff.dao.CriteriaCallback;
import org.dellroad.stuff.dao.DAO;
import org.dellroad.stuff.dao.QueryCallback;
import org.dellroad.stuff.dao.TypedQueryCallback;
import org.dellroad.stuff.dao.UpdateCallback;
import org.dellroad.stuff.spring.AbstractBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractDAO<T>
extends AbstractBean
implements DAO<T> {
    protected final Class<T> type;
    private EntityManager entityManager;

    protected AbstractDAO(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = type;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getEntityManager() == null) {
            throw new IllegalArgumentException("no entityManager configured");
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getById(long id) {
        return (T)this.getEntityManager().find(this.type, (Object)id);
    }

    public List<T> getAll() {
        return (List)this.getBy((QueryCallback)new DAOCriteriaListCallback(this){

            protected void configureQuery(CriteriaQuery<T> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                criteriaQuery.from(this.type);
            }
        });
    }

    public T getReference(long id) {
        return (T)this.getEntityManager().getReference(this.type, (Object)id);
    }

    protected List<T> find(final String queryString, final Object ... params) {
        return (List)this.getBy((QueryCallback)new DAOQueryListCallback(this){

            protected TypedQuery<T> buildQuery(EntityManager em) {
                return this.buildQuery(em, queryString, params);
            }
        });
    }

    protected T findUnique(final String queryString, final Object ... params) {
        return (T)this.getBy((QueryCallback)new DAOQueryUniqueCallback(this){

            protected TypedQuery<T> buildQuery(EntityManager em) {
                return this.buildQuery(em, queryString, params);
            }
        });
    }

    protected <R> R getBy(QueryCallback<R> callback) {
        return (R)callback.query(this.getEntityManager());
    }

    protected int bulkUpdate(UpdateCallback callback) {
        return (Integer)callback.query(this.getEntityManager());
    }

    public void save(T obj) {
        this.getEntityManager().persist(obj);
    }

    public void delete(T obj) {
        this.getEntityManager().remove(obj);
    }

    public T merge(T obj) {
        return (T)this.getEntityManager().merge(obj);
    }

    public void refresh(T obj) {
        this.getEntityManager().refresh(obj);
    }

    public void detach(Object obj) {
        this.getEntityManager().detach(obj);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public boolean isReadOnly() {
        return TransactionSynchronizationManager.isCurrentTransactionReadOnly();
    }

    public boolean contains(T obj) {
        return this.getEntityManager().contains(obj);
    }

    protected T cast(Object obj) {
        return this.type.cast(obj);
    }

    protected List<T> castList(List<?> list) {
        return list;
    }

    private TypedQuery<T> buildQuery(EntityManager em, String queryString, Object[] params) {
        TypedQuery query = em.createQuery(queryString, this.type);
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                query.setParameter(i + 1, params[i]);
                ++i;
            }
        }
        return query;
    }

    protected abstract class DAOCriteriaListCallback
    extends CriteriaCallback<T, List<T>> {
        protected DAOCriteriaListCallback() {
            super(AbstractDAO.this.type);
        }

        protected final List<T> executeQuery(TypedQuery<T> query) {
            return query.getResultList();
        }
    }

    protected abstract class DAOCriteriaUniqueCallback
    extends CriteriaCallback<T, T> {
        protected DAOCriteriaUniqueCallback() {
            super(AbstractDAO.this.type);
        }

        protected final T executeQuery(TypedQuery<T> query) {
            try {
                return query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                return null;
            }
        }
    }

    protected abstract class DAOQueryListCallback
    extends TypedQueryCallback<T, List<T>> {
        protected DAOQueryListCallback() {
        }

        protected final List<T> executeQuery(TypedQuery<T> query) {
            return query.getResultList();
        }
    }

    protected abstract class DAOQueryUniqueCallback
    extends TypedQueryCallback<T, T> {
        protected DAOQueryUniqueCallback() {
        }

        protected final T executeQuery(TypedQuery<T> query) {
            try {
                return query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                return null;
            }
        }
    }
}

