/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import org.springframework.beans.factory.ListableBeanFactory;

public class BeanNameComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 5748344324099448841L;
    private final HashMap<String, Integer> beanNameMap;
    private final String factoryName;

    public BeanNameComparator(ListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        this.beanNameMap = new HashMap(beanNames.length);
        int i = 0;
        while (i < beanNames.length) {
            this.beanNameMap.put(beanNames[i], i);
            ++i;
        }
        this.factoryName = "" + beanFactory;
    }

    @Override
    public int compare(String name1, String name2) {
        Integer index1 = this.beanNameMap.get(name1);
        Integer index2 = this.beanNameMap.get(name2);
        if (index1 == null) {
            throw new IllegalArgumentException("failed to find bean `" + name1 + "' in bean factory " + this.factoryName);
        }
        if (index2 == null) {
            throw new IllegalArgumentException("failed to find bean `" + name2 + "' in bean factory " + this.factoryName);
        }
        return index1 - index2;
    }
}

