/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.springframework.scheduling.TaskScheduler;

public abstract class DelayedAction
implements Runnable {
    private final Lock lock;
    private final Object objLock;
    private final TaskScheduler taskScheduler;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> future;
    private Date futureDate;

    protected DelayedAction(Object lock, TaskScheduler taskScheduler) {
        this(null, lock, taskScheduler, null);
        if (taskScheduler == null) {
            throw new IllegalArgumentException("null taskScheduler");
        }
    }

    protected DelayedAction(Object lock, ScheduledExecutorService executorService) {
        this(null, lock, null, executorService);
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
    }

    protected DelayedAction(Lock lock, TaskScheduler taskScheduler) {
        this(lock, null, taskScheduler, null);
        if (lock == null) {
            throw new IllegalArgumentException("null lock");
        }
        if (taskScheduler == null) {
            throw new IllegalArgumentException("null taskScheduler");
        }
    }

    protected DelayedAction(Lock lock, ScheduledExecutorService executorService) {
        this(lock, null, null, executorService);
        if (lock == null) {
            throw new IllegalArgumentException("null lock");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
    }

    private DelayedAction(Lock lock, Object objLock, TaskScheduler taskScheduler, ScheduledExecutorService executorService) {
        this.lock = lock;
        this.objLock = lock != null ? null : (objLock != null ? objLock : this);
        this.taskScheduler = taskScheduler;
        this.executorService = executorService;
    }

    public void schedule(final Date date) {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.scheduleWhileLocked(date);
            }
        });
    }

    private void scheduleWhileLocked(final Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null date");
        }
        if (this.future != null) {
            if (date.compareTo(this.futureDate) >= 0) {
                return;
            }
            this.cancel();
        }
        this.future = this.schedule(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.futureInvoked(date);
            }
        }, date);
        this.futureDate = date;
    }

    public void cancel() {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.cancelWhileLocked();
            }
        });
    }

    private void cancelWhileLocked() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(false);
        this.future = null;
        this.futureDate = null;
    }

    public boolean isScheduled() {
        final boolean[] result = new boolean[1];
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                result[0] = DelayedAction.this.future != null;
            }
        });
        return result[0];
    }

    public Date getScheduledTime() {
        final Date[] result = new Date[1];
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                result[0] = DelayedAction.this.futureDate;
            }
        });
        return result[0];
    }

    protected ScheduledFuture<?> schedule(Runnable action, Date date) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        if (date == null) {
            throw new IllegalArgumentException("null date");
        }
        if (this.taskScheduler != null) {
            return this.taskScheduler.schedule(action, date);
        }
        long now = System.currentTimeMillis();
        long when = date.getTime();
        if (when < now) {
            when = now;
        }
        return this.executorService.schedule(action, when - now, TimeUnit.MILLISECONDS);
    }

    private void futureInvoked(final Date date) {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.futureInvokedWhileLocked(date);
            }
        });
    }

    private void futureInvokedWhileLocked(Date date) {
        if (this.futureDate != date) {
            return;
        }
        this.future = null;
        this.futureDate = null;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocked(Runnable action) {
        if (this.objLock != null) {
            Object object = this.objLock;
            synchronized (object) {
                action.run();
            }
        }
        this.lock.lock();
        try {
            action.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

