/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Random;
import org.aspectj.internal.lang.annotation.ajcDeclarePrecedence;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.AroundClosure;
import org.dellroad.stuff.spring.AbstractBean;
import org.dellroad.stuff.spring.RetryTransaction;
import org.dellroad.stuff.spring.RetryTransactionProvider;
import org.slf4j.Logger;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.dao.UncategorizedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class RetryTransactionAspect
extends AbstractBean
implements RetryTransactionProvider {
    private final ThreadLocal<ArrayDeque<RetryInfo>> retryInfos = new ThreadLocal<ArrayDeque<RetryInfo>>(this){
        final /* synthetic */ RetryTransactionAspect this$0;
        {
            this.this$0 = retryTransactionAspect;
        }

        public ArrayDeque<RetryInfo> initialValue() {
            return new ArrayDeque<RetryInfo>(2);
        }
    };
    private final Random random = new Random();
    private int maxRetriesDefault = 4;
    private long initialDelayDefault = 100L;
    private long maximumDelayDefault = 30000L;
    private final AnnotationTransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource(false);
    private PersistenceExceptionTranslator persistenceExceptionTranslator;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RetryTransactionAspect ajc$perSingletonInstance;

    static {
        try {
            RetryTransactionAspect.ajc$perSingletonInstance = new RetryTransactionAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Override
    public PersistenceExceptionTranslator getPersistenceExceptionTranslator() {
        return this.persistenceExceptionTranslator;
    }

    public void setPersistenceExceptionTranslator(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    @Override
    public int getMaxRetriesDefault() {
        return this.maxRetriesDefault;
    }

    public void setMaxRetriesDefault(int maxRetriesDefault) {
        this.maxRetriesDefault = maxRetriesDefault;
    }

    @Override
    public long getInitialDelayDefault() {
        return this.initialDelayDefault;
    }

    public void setInitialDelayDefault(long initialDelayDefault) {
        this.initialDelayDefault = initialDelayDefault;
    }

    @Override
    public long getMaximumDelayDefault() {
        return this.maximumDelayDefault;
    }

    public void setMaximumDelayDefault(long maximumDelayDefault) {
        this.maximumDelayDefault = maximumDelayDefault;
    }

    @Override
    public int getAttemptNumber() {
        return this.getAttemptNumber(null);
    }

    @Override
    public int getAttemptNumber(String transactionManagerName) {
        ArrayDeque<RetryInfo> retryInfoStack = this.retryInfos.get();
        Iterator<RetryInfo> i = retryInfoStack.descendingIterator();
        while (i.hasNext()) {
            RetryInfo retryInfo = i.next();
            if (transactionManagerName != null && !transactionManagerName.equals(retryInfo.getTransactionManagerName())) continue;
            return retryInfo.getAttemptNumber();
        }
        return 0;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("no PersistenceExceptionTranslator configured");
        }
    }

    @ajcDeclarePrecedence(value="(org.springframework.scheduling.aspectj.*, org.dellroad.stuff.spring.RetryTransactionAspect, org.springframework.transaction.aspectj.*)")
    /* synthetic */ void ajc$declare_precedence_1() {
    }

    @Around(value="retryTransactionalMethodExecution(txObject)", argNames="txObject,ajc$aroundClosure")
    public Object ajc$around$org_dellroad_stuff_spring_RetryTransactionAspect$1$878f3a34(Object txObject, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        long maximumDelay;
        MethodSignature methodSignature = (MethodSignature)thisJoinPointStaticPart.getSignature();
        Method method = methodSignature.getMethod();
        TransactionAttribute transactionAttribute = this.transactionAttributeSource.getTransactionAttribute(method, txObject.getClass());
        if (transactionAttribute == null) {
            throw new RuntimeException("no @Transactional annotation found for method " + method + "; required for @RetryTransaction");
        }
        String transactionManagerName = transactionAttribute.getQualifier();
        switch (transactionAttribute.getPropagationBehavior()) {
            case 3: {
                break;
            }
            case 0: {
                if (!TransactionSynchronizationManager.isActualTransactionActive() || this.getAttemptNumber(transactionManagerName) <= 0) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("skipping retry logic; transaction already open for tx manager {} in @Transactional method {}", (Object)transactionManagerName, (Object)method);
                }
                return ajc$aroundClosure.run(new Object[]{txObject});
            }
            default: {
                return ajc$aroundClosure.run(new Object[]{txObject});
            }
        }
        RetryTransaction retryTransaction = (RetryTransaction)AnnotationUtils.getAnnotation((Method)method, RetryTransaction.class);
        if (retryTransaction == null) {
            retryTransaction = (RetryTransaction)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RetryTransaction.class);
        }
        if (retryTransaction == null) {
            throw new RuntimeException("internal error: no @RetryTransaction annotation found for method " + method);
        }
        int maxRetries = retryTransaction.maxRetries() != -1 ? retryTransaction.maxRetries() : this.maxRetriesDefault;
        long initialDelay = retryTransaction.initialDelay() != -1L ? retryTransaction.initialDelay() : this.initialDelayDefault;
        long l = maximumDelay = retryTransaction.maximumDelay() != -1L ? retryTransaction.maximumDelay() : this.maximumDelayDefault;
        if (this.persistenceExceptionTranslator == null) {
            throw new RuntimeException("@RetryTransaction aspect must be configured before use");
        }
        RetryInfo retryInfo = new RetryInfo(transactionManagerName);
        while (true) {
            int attempt = retryInfo.getAttemptNumber();
            if (retryInfo.getAttemptNumber() > 1) {
                long delay = this.calculateDelay(attempt, initialDelay, maximumDelay);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("pausing {}ms before retrying @Transactional method {}", (Object)delay, (Object)method);
                }
                this.pause(delay);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("retrying @Transactional method {} (attempt #{})", (Object)method, (Object)attempt);
                }
            }
            try {
                Object result;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("starting @Transactional method {} (attempt #{})", (Object)method, (Object)attempt);
                }
                ((ArrayDeque)this.retryInfos.get()).push(retryInfo);
                try {
                    result = ajc$aroundClosure.run(new Object[]{txObject});
                }
                finally {
                    ((ArrayDeque)this.retryInfos.get()).pop();
                }
                if (attempt > 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("successfully completed @Transactional method {} on re-try attempt #{}", (Object)method, (Object)attempt);
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("successfully completed @Transactional method {} on first attempt", (Object)method);
                }
                return result;
            }
            catch (RuntimeException e) {
                DataAccessException translatedException = e instanceof UncategorizedDataAccessException && e.getCause() instanceof RuntimeException ? this.persistenceExceptionTranslator.translateExceptionIfPossible((RuntimeException)e.getCause()) : (e instanceof DataAccessException ? (DataAccessException)e : this.persistenceExceptionTranslator.translateExceptionIfPossible(e));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exception from @Transactional method {} on attempt #{}: {} (translates to {})", new Object[]{method, attempt, e, translatedException != null ? translatedException.getClass().getSimpleName() : null});
                }
                if (!(translatedException instanceof TransientDataAccessException)) {
                    throw e;
                }
                TransientDataAccessException transientException = (TransientDataAccessException)translatedException;
                if (retryInfo.incrementAttemptNumber() <= maxRetries) continue;
                this.log.error("@Transactional method {} failed after {} attempts, giving up!", (Object)method, (Object)maxRetries);
                throw transientException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long calculateDelay(int attempt, long initialDelay, long maximumDelay) {
        initialDelay = Math.max(initialDelay, 1L);
        maximumDelay = Math.max(maximumDelay, 1L);
        long delay = initialDelay = Math.min(initialDelay, maximumDelay);
        while (attempt-- > 1) {
            if ((delay <<= 1) < maximumDelay) continue;
            delay = maximumDelay;
            break;
        }
        int randomRange = Math.max(1, (int)(delay >> 3));
        Random random = this.random;
        synchronized (random) {
            delay += (long)(this.random.nextInt(randomRange) - randomRange / 2);
        }
        delay = Math.min(delay, maximumDelay);
        return delay;
    }

    protected void pause(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Pointcut(value="(execution(public * (@org.springframework.transaction.annotation.Transactional *).*(..)) || execution(public * (@((@org.springframework.transaction.annotation.Transactional *)) *).*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfPublicMethodInTransactionalType$3197() {
    }

    @Pointcut(value="(execution(public * (@org.dellroad.stuff.spring.RetryTransaction *).*(..)) || execution(public * (@((@org.dellroad.stuff.spring.RetryTransaction *)) *).*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfPublicMethodInRetryTransactionType$330c() {
    }

    @Pointcut(value="(execution(@org.springframework.transaction.annotation.Transactional * *(..)) || execution(@((@org.springframework.transaction.annotation.Transactional *)) * *(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfTransactionalMethod$342e() {
    }

    @Pointcut(value="(execution(@org.dellroad.stuff.spring.RetryTransaction * *(..)) || execution(@((@org.dellroad.stuff.spring.RetryTransaction *)) * *(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$executionOfRetryTransactionMethod$3522() {
    }

    @Pointcut(value="(this(txObject) && ((executionOfPublicMethodInTransactionalType() || executionOfTransactionalMethod()) && (executionOfPublicMethodInRetryTransactionType() || executionOfRetryTransactionMethod())))", argNames="txObject")
    private /* synthetic */ void ajc$pointcut$$retryTransactionalMethodExecution$3636(Object object) {
    }

    public static RetryTransactionAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org_dellroad_stuff_spring_RetryTransactionAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$persistenceExceptionTranslator(RetryTransactionAspect retryTransactionAspect, PersistenceExceptionTranslator persistenceExceptionTranslator) {
        retryTransactionAspect.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$log(RetryTransactionAspect retryTransactionAspect, Logger logger) {
        retryTransactionAspect.log = logger;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$retryInfos(RetryTransactionAspect retryTransactionAspect, ThreadLocal threadLocal) {
        retryTransactionAspect.retryInfos = threadLocal;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$transactionAttributeSource(RetryTransactionAspect retryTransactionAspect, AnnotationTransactionAttributeSource annotationTransactionAttributeSource) {
        retryTransactionAspect.transactionAttributeSource = annotationTransactionAttributeSource;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$maxRetriesDefault(RetryTransactionAspect retryTransactionAspect, int n) {
        retryTransactionAspect.maxRetriesDefault = n;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$maximumDelayDefault(RetryTransactionAspect retryTransactionAspect, long l) {
        retryTransactionAspect.maximumDelayDefault = l;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_dellroad_stuff_spring_RetryTransactionAspect$org_dellroad_stuff_spring_RetryTransactionAspect$initialDelayDefault(RetryTransactionAspect retryTransactionAspect, long l) {
        retryTransactionAspect.initialDelayDefault = l;
    }

    private static class RetryInfo {
        private final String transactionManagerName;
        private int attemptNumber = 1;

        public RetryInfo(String transactionManagerName) {
            this.transactionManagerName = transactionManagerName;
        }

        public String getTransactionManagerName() {
            return this.transactionManagerName;
        }

        public int getAttemptNumber() {
            return this.attemptNumber;
        }

        public int incrementAttemptNumber() {
            return this.attemptNumber++;
        }
    }
}

