/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.AbstractInMemoryContainer;
import com.vaadin.data.util.DefaultItemSorter;
import com.vaadin.data.util.ItemSorter;
import com.vaadin.data.util.filter.SimpleStringFilter;
import com.vaadin.data.util.filter.UnsupportedFilterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dellroad.stuff.vaadin7.BackedItem;
import org.dellroad.stuff.vaadin7.Connectable;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ProvidesPropertyScanner;
import org.dellroad.stuff.vaadin7.SimpleItem;
import org.dellroad.stuff.vaadin7.SortingPropertyExtractor;

public abstract class AbstractSimpleContainer<I, T>
extends AbstractInMemoryContainer<I, String, BackedItem<T>>
implements PropertyExtractor<T>,
Container.Filterable,
Container.SimpleFilterable,
Container.Sortable,
Connectable {
    private final HashMap<String, PropertyDef<?>> propertyMap = new HashMap();
    private final HashMap<Object, BackedItem<T>> itemMap = new HashMap();
    private PropertyExtractor<? super T> propertyExtractor;

    protected AbstractSimpleContainer() {
        this((PropertyExtractor<T>)null);
    }

    protected AbstractSimpleContainer(PropertyExtractor<? super T> propertyExtractor) {
        this(propertyExtractor, null);
    }

    protected AbstractSimpleContainer(Collection<? extends PropertyDef<?>> propertyDefs) {
        this(null, propertyDefs);
    }

    protected AbstractSimpleContainer(PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        this.setItemSorter((ItemSorter)new SimpleItemSorter());
        this.setPropertyExtractor(propertyExtractor);
        this.setProperties(propertyDefs);
    }

    protected AbstractSimpleContainer(Class<? super T> type) {
        ProvidesPropertyScanner<T> propertyReader = new ProvidesPropertyScanner<T>(type);
        this.setItemSorter((ItemSorter)new SimpleItemSorter());
        this.setPropertyExtractor(propertyReader.getPropertyExtractor());
        this.setProperties(propertyReader.getPropertyDefs());
    }

    public PropertyExtractor<? super T> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<? super T> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public <V> V getPropertyValue(T obj, PropertyDef<V> propertyDef) {
        if (this.propertyExtractor == null) {
            throw new IllegalStateException("no PropertyExtractor is configured for this container");
        }
        return this.propertyExtractor.getPropertyValue(obj, propertyDef);
    }

    public void setProperties(Collection<? extends PropertyDef<?>> propertyDefs) {
        if (propertyDefs == null) {
            propertyDefs = Collections.emptySet();
        }
        this.propertyMap.clear();
        for (PropertyDef<?> propertyDef : propertyDefs) {
            if (this.propertyMap.put(propertyDef.getName(), propertyDef) == null) continue;
            throw new IllegalArgumentException("duplicate property name `" + propertyDef.getName() + "'");
        }
        this.fireContainerPropertySetChange();
    }

    public void setProperty(PropertyDef<?> propertyDef) {
        if (propertyDef == null) {
            throw new IllegalArgumentException("null propertyDef");
        }
        this.propertyMap.put(propertyDef.getName(), propertyDef);
        this.fireContainerPropertySetChange();
    }

    public void load(Iterable<? extends T> contents) {
        this.load(contents.iterator());
    }

    public void load(Iterator<? extends T> contents) {
        if (contents == null) {
            throw new IllegalArgumentException("null contents");
        }
        this.resetItemIds();
        this.internalRemoveAllItems();
        int index = 0;
        while (contents.hasNext()) {
            T obj = contents.next();
            if (obj == null) {
                throw new IllegalArgumentException("null item in contents at index " + index);
            }
            BackedItem<T> item = this.createBackedItem(obj, this.propertyMap.values(), this);
            this.internalAddItemAtEnd(this.generateItemId(obj), item, false);
            ++index;
        }
        this.doFilterContainer(!this.getFilters().isEmpty());
        this.afterReload();
        this.fireItemSetChange();
    }

    protected void internalRemoveAllItems() {
        super.internalRemoveAllItems();
        this.itemMap.clear();
    }

    public I getItemIdFor(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null object");
        }
        for (Object itemId : this.getItemIds()) {
            T candidate = this.getJavaObject(itemId);
            if (!obj.equals(candidate)) continue;
            return (I)itemId;
        }
        return null;
    }

    public I getItemIdForSame(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null object");
        }
        for (Object itemId : this.getItemIds()) {
            T candidate = this.getJavaObject(itemId);
            if (obj != candidate) continue;
            return (I)itemId;
        }
        return null;
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
    }

    public List<I> getItemIds() {
        return super.getItemIds();
    }

    public Set<String> getContainerPropertyIds() {
        return Collections.unmodifiableSet(this.propertyMap.keySet());
    }

    public Property<?> getContainerProperty(Object itemId, Object propertyId) {
        BackedItem entityItem = (BackedItem)this.getItem(itemId);
        if (entityItem == null) {
            return null;
        }
        return entityItem.getItemProperty(propertyId);
    }

    public Class<?> getType(Object propertyId) {
        PropertyDef<?> propertyDef = this.propertyMap.get(propertyId);
        return propertyDef != null ? propertyDef.getType() : null;
    }

    public BackedItem<T> getUnfilteredItem(Object itemId) {
        T obj = this.getJavaObject(itemId);
        if (obj == null) {
            return null;
        }
        BackedItem<T> item = this.itemMap.get(itemId);
        if (item == null) {
            item = this.createBackedItem(obj, this.propertyMap.values(), this);
            this.itemMap.put(itemId, item);
        }
        return item;
    }

    public abstract T getJavaObject(Object var1);

    protected abstract void resetItemIds();

    protected abstract I generateItemId(T var1);

    protected void afterReload() {
    }

    protected BackedItem<T> createBackedItem(T object, Collection<PropertyDef<?>> propertyDefs, PropertyExtractor<? super T> propertyExtractor) {
        return new SimpleItem<T>(object, propertyDefs, propertyExtractor);
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        super.sortContainer(propertyId, ascending);
    }

    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        try {
            this.addFilter((Container.Filter)new SimpleStringFilter(propertyId, filterString, ignoreCase, onlyMatchPrefix));
        }
        catch (UnsupportedFilterException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public Collection<Container.Filter> getContainerFilters() {
        return super.getContainerFilters();
    }

    public void removeAllContainerFilters() {
        this.removeAllFilters();
    }

    public void removeContainerFilters(Object propertyId) {
        this.removeFilters(propertyId);
    }

    public void addContainerFilter(Container.Filter filter) {
        this.addFilter(filter);
    }

    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(filter);
    }

    public Collection<?> getSortableContainerPropertyIds() {
        ArrayList<String> propertyIds = new ArrayList<String>(this.propertyMap.size());
        for (Map.Entry<String, PropertyDef<?>> entry : this.propertyMap.entrySet()) {
            SortingPropertyExtractor sortingPropertyExtractor;
            if (this.propertyExtractor instanceof SortingPropertyExtractor && (sortingPropertyExtractor = (SortingPropertyExtractor)this.propertyExtractor).canSort(entry.getValue())) {
                propertyIds.add(entry.getKey());
                continue;
            }
            if (!entry.getValue().isSortable()) continue;
            propertyIds.add(entry.getKey());
        }
        return propertyIds;
    }

    private class SimpleItemSorter
    extends DefaultItemSorter {
        private SimpleItemSorter() {
        }

        protected int compareProperty(Object propertyId, boolean ascending, Item item1, Item item2) {
            SortingPropertyExtractor sortingPropertyExtractor;
            PropertyDef propertyDef = (PropertyDef)AbstractSimpleContainer.this.propertyMap.get(propertyId);
            if (propertyDef == null) {
                return super.compareProperty(propertyId, ascending, item1, item2);
            }
            if (AbstractSimpleContainer.this.propertyExtractor instanceof SortingPropertyExtractor && (sortingPropertyExtractor = (SortingPropertyExtractor)AbstractSimpleContainer.this.propertyExtractor).canSort(propertyDef)) {
                Object obj1 = ((BackedItem)item1).getObject();
                Object obj2 = ((BackedItem)item2).getObject();
                int diff = sortingPropertyExtractor.sort(propertyDef, obj1, obj2);
                return ascending ? diff : -diff;
            }
            if (propertyDef.isSortable()) {
                int diff = this.sort(propertyDef, item1, item2);
                return ascending ? diff : -diff;
            }
            return super.compareProperty(propertyId, ascending, item1, item2);
        }

        private <V> int sort(PropertyDef<V> propertyDef, Item item1, Item item2) {
            return propertyDef.sort(propertyDef.read(item1), propertyDef.read(item2));
        }
    }
}

