/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Container;
import java.util.Collection;
import java.util.List;
import org.dellroad.stuff.vaadin7.AbstractQueryContainer;
import org.dellroad.stuff.vaadin7.AlwaysInvalidQueryList;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.QueryList;
import org.dellroad.stuff.vaadin7.WindowQueryList;

public abstract class AbstractUnsizedContainer<T>
extends AbstractQueryContainer<T> {
    public static final int DEFAULT_WINDOW_SIZE = 50;
    private final int windowSize;
    private long size;
    private boolean sizeIsKnown;

    protected AbstractUnsizedContainer() {
        this(50);
    }

    protected AbstractUnsizedContainer(PropertyExtractor<? super T> propertyExtractor) {
        this(50, propertyExtractor);
    }

    protected AbstractUnsizedContainer(Collection<? extends PropertyDef<?>> propertyDefs) {
        this(50, propertyDefs);
    }

    protected AbstractUnsizedContainer(PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        this(50, propertyExtractor, propertyDefs);
    }

    protected AbstractUnsizedContainer(int windowSize) {
        this(windowSize, (PropertyExtractor<T>)null);
    }

    protected AbstractUnsizedContainer(int windowSize, PropertyExtractor<? super T> propertyExtractor) {
        this(windowSize, propertyExtractor, null);
    }

    protected AbstractUnsizedContainer(int windowSize, Collection<? extends PropertyDef<?>> propertyDefs) {
        this(windowSize, null, propertyDefs);
    }

    protected AbstractUnsizedContainer(int windowSize, PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        super(propertyExtractor, propertyDefs);
        if (windowSize < 1) {
            throw new IllegalArgumentException("windowSize = " + windowSize);
        }
        this.windowSize = windowSize;
    }

    protected AbstractUnsizedContainer(Class<? super T> type) {
        this(50, type);
    }

    protected AbstractUnsizedContainer(int windowSize, Class<? super T> type) {
        super(type);
        if (windowSize < 1) {
            throw new IllegalArgumentException("windowSize = " + windowSize);
        }
        this.windowSize = windowSize;
    }

    @Override
    protected QueryList<T> query(long hint) {
        hint = Math.min(hint, this.size - 1L);
        long offset = Math.max(0L, (hint = Math.max(hint, 0L)) - (long)(this.windowSize / 2));
        List<T> window = this.queryWindow(offset, this.windowSize);
        int querySize = window.size();
        if (querySize <= 0) {
            if (offset == 0L) {
                this.sizeIsKnown = true;
                this.size = 0L;
            } else {
                this.sizeIsKnown = false;
                this.size = this.getSmallerEstimate(offset);
                return new AlwaysInvalidQueryList(this.size);
            }
        }
        if (querySize < this.windowSize) {
            this.size = offset + (long)querySize;
            this.sizeIsKnown = true;
            return new WindowQueryList<T>(offset, window, this.size);
        }
        if (!this.sizeIsKnown) {
            long lowerBound = offset + (long)querySize;
            if (this.size < lowerBound + 1L) {
                long largerSize = this.getLargerEstimate(lowerBound);
                largerSize = Math.max(largerSize, lowerBound + (long)this.windowSize);
                this.size = Math.max(this.size, largerSize);
            }
        } else {
            this.size = Math.max(this.size, offset + (long)querySize);
        }
        return new WindowQueryList<T>(offset, window, this.size);
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public long getCurrentSizeEstimate() {
        return this.size;
    }

    protected long getSmallerEstimate(long upperBound) {
        return (upperBound >> 1) + (upperBound >> 2);
    }

    protected long getLargerEstimate(long lowerBound) {
        return lowerBound + (lowerBound >> 2);
    }

    protected void fireItemSetChange(Container.ItemSetChangeEvent event) {
        this.sizeIsKnown = false;
        super.fireItemSetChange(event);
    }

    protected abstract List<? extends T> queryWindow(long var1, int var3);

    @Override
    protected abstract void handleSizeChange();
}

