/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Field;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.dellroad.stuff.java.MethodAnnotationScanner;

public class FieldBuilder {
    public void buildAndBind(BeanFieldGroup<?> fieldGroup) {
        if (fieldGroup == null) {
            throw new IllegalArgumentException("null beanType");
        }
        BeanItem beanItem = fieldGroup.getItemDataSource();
        if (beanItem == null) {
            throw new IllegalArgumentException("fieldGroup does not yet have a data source");
        }
        for (Map.Entry<String, Field<?>> entry : this.buildBeanPropertyFields(beanItem.getBean()).entrySet()) {
            fieldGroup.bind(entry.getValue(), (Object)entry.getKey());
        }
    }

    public Map<String, Field<?>> buildBeanPropertyFields(Object bean) {
        Method method;
        BeanInfo beanInfo;
        if (bean == null) {
            throw new IllegalArgumentException("null bean");
        }
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        HashMap<String, Method> getterMap = new HashMap<String, Method>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            method = propertyDescriptor.getReadMethod();
            if (method != null && method.getClass() != bean.getClass()) {
                Class<?> c = bean.getClass();
                while (c != null && c != method.getClass()) {
                    try {
                        method = c.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (Exception exception) {
                        c = c.getSuperclass();
                    }
                }
            }
            if (method != null && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
                getterMap.put(propertyDescriptor.getName(), method);
            }
            ++n2;
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : getterMap.entrySet()) {
            String propertyName = (String)entry.getKey();
            method = (Method)entry.getValue();
            List<AnnotationApplier<?, ?>> applierList = this.buildApplierList(method);
            if (applierList.isEmpty()) continue;
            map.put(propertyName, (Field<?>)this.buildField(applierList, "method " + method));
        }
        HashMap<String, Method> providerMap = new HashMap<String, Method>();
        this.buildProviderMap(providerMap, bean.getClass());
        for (Map.Entry entry : providerMap.entrySet()) {
            Field field;
            String propertyName = (String)entry.getKey();
            Method method2 = (Method)entry.getValue();
            if (map.containsKey(propertyName)) {
                throw new IllegalArgumentException("conflicting annotations exist for property `" + propertyName + "': annotation @" + ProvidesField.class.getName() + " on method " + method2 + " cannot be combined with other @FieldBuilder.* annotation types");
            }
            try {
                method2.setAccessible(true);
            }
            catch (Exception exception) {}
            try {
                field = (Field)method2.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("error invoking @" + ProvidesField.class.getName() + " annotation on method " + method2, e);
            }
            map.put(propertyName, field);
        }
        return map;
    }

    private <T> void buildProviderMap(Map<String, Method> providerMap, Class<T> type) {
        MethodAnnotationScanner scanner = new MethodAnnotationScanner(type, ProvidesField.class);
        for (MethodAnnotationScanner.MethodInfo methodInfo : scanner.findAnnotatedMethods()) {
            this.buildProviderMap(providerMap, methodInfo.getMethod().getDeclaringClass(), methodInfo.getMethod().getName());
        }
    }

    private void buildProviderMap(Map<String, Method> providerMap, Class<?> type, String methodName) {
        block8: {
            Method method;
            if (type == null) {
                return;
            }
            try {
                method = type.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                break block8;
            }
            ProvidesField providesField = method.getAnnotation(ProvidesField.class);
            if (providesField != null) {
                if (!Field.class.isAssignableFrom(method.getReturnType())) {
                    throw new IllegalArgumentException("invalid @" + ProvidesField.class.getName() + " annotation on method " + method + ": return type " + method.getReturnType().getName() + " is not a subtype of " + Field.class.getName());
                }
                String propertyName = providesField.value();
                Method otherMethod = providerMap.get(propertyName);
                if (otherMethod != null && !otherMethod.getName().equals(methodName)) {
                    throw new IllegalArgumentException("conflicting @" + ProvidesField.class.getName() + " annotations exist for property `" + propertyName + "': both method " + otherMethod + " and method " + method + " are specified");
                }
                if (otherMethod == null) {
                    providerMap.put(propertyName, method);
                }
            }
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.buildProviderMap(providerMap, iface, methodName);
            ++n2;
        }
        this.buildProviderMap(providerMap, type.getSuperclass(), methodName);
    }

    public static <T> BeanFieldGroup<T> buildFieldGroup(T bean) {
        if (bean == null) {
            throw new IllegalArgumentException("null bean");
        }
        BeanFieldGroup fieldGroup = new BeanFieldGroup(bean.getClass());
        fieldGroup.setItemDataSource(bean);
        new FieldBuilder().buildAndBind(fieldGroup);
        return fieldGroup;
    }

    protected com.vaadin.ui.AbstractField<?> buildField(Collection<AnnotationApplier<?, ?>> appliers, String description) {
        Comparator comparator = new Comparator<AnnotationApplier<?, ?>>(){

            @Override
            public int compare(AnnotationApplier<?, ?> a1, AnnotationApplier<?, ?> a2) {
                Class<?> type2;
                Class<?> type1 = a1.getFieldType();
                if (type1 == (type2 = a2.getFieldType())) {
                    return 0;
                }
                if (type1.isAssignableFrom(type2)) {
                    return 1;
                }
                if (type2.isAssignableFrom(type1)) {
                    return -1;
                }
                return 0;
            }
        };
        ArrayList applierList = new ArrayList(appliers);
        Collections.sort(applierList, comparator);
        int i = 0;
        while (i < applierList.size() - 1) {
            AnnotationApplier<?, ?> a1 = applierList.get(i);
            AnnotationApplier<?, ?> a2 = applierList.get(i + 1);
            if (((Annotation)a1.getAnnotation()).annotationType() == ((Annotation)a2.getAnnotation()).annotationType()) {
                applierList.remove(i + 1);
                continue;
            }
            if (comparator.compare(a1, a2) == 0) {
                throw new IllegalArgumentException("conflicting annotations of type " + ((Annotation)a1.getAnnotation()).annotationType().getName() + " and " + ((Annotation)a2.getAnnotation()).annotationType().getName() + " for " + description);
            }
            ++i;
        }
        Class<?> type = null;
        AnnotationApplier<?, ?> typeApplier = null;
        for (AnnotationApplier<?, ?> applier : applierList) {
            if (applier.getActualFieldType() == null) continue;
            if (type == null) {
                type = applier.getActualFieldType();
                typeApplier = applier;
                continue;
            }
            if (applier.getActualFieldType().isAssignableFrom(type) || typeApplier == null) continue;
            throw new IllegalArgumentException("conflicting field types specified by annotations of type " + ((Annotation)typeApplier.getAnnotation()).annotationType().getName() + " (type() = " + type.getName() + ") and " + ((Annotation)applier.getAnnotation()).annotationType().getName() + " (type() = " + applier.getActualFieldType().getName() + ") for " + description);
        }
        if (type == null) {
            throw new IllegalArgumentException("cannot determine field type; no type() specified for " + description);
        }
        com.vaadin.ui.AbstractField field = (com.vaadin.ui.AbstractField)FieldBuilder.instantiate(type);
        for (AnnotationApplier<?, ?> applier : applierList) {
            this.apply(applier, field);
        }
        return field;
    }

    private <F extends com.vaadin.ui.AbstractField<?>> void apply(AnnotationApplier<?, F> applier, com.vaadin.ui.AbstractField<?> field) {
        applier.applyTo((com.vaadin.ui.AbstractField)applier.getFieldType().cast(field));
    }

    private static <T> T instantiate(Class<T> type) {
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot instantiate " + type + " because no zero-arg constructor could be found", e);
        }
        try {
            constructor.setAccessible(true);
        }
        catch (Exception exception) {}
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot instantiate " + type + " using its zero-arg constructor", e);
        }
    }

    protected List<AnnotationApplier<?, ?>> buildApplierList(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalArgumentException("method takes parameters");
        }
        ArrayList list = new ArrayList();
        this.buildApplierList(method.getDeclaringClass(), method.getName(), list);
        return list;
    }

    private void buildApplierList(Class<?> type, String methodName, List<AnnotationApplier<?, ?>> list) {
        Method method;
        if (type == null) {
            return;
        }
        try {
            method = type.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        if (method != null) {
            list.addAll(this.buildDirectApplierList(method));
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.buildApplierList(iface, methodName, list);
            ++n2;
        }
        this.buildApplierList(type.getSuperclass(), methodName, list);
    }

    protected List<AnnotationApplier<?, ?>> buildDirectApplierList(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        ArrayList list = new ArrayList();
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            AnnotationApplier<?, ?> applier = this.getAnnotationApplier(method, annotation);
            if (applier != null) {
                list.add(applier);
            }
            ++n2;
        }
        return list;
    }

    protected AnnotationApplier<?, ?> getAnnotationApplier(Method method, Annotation annotation) {
        if (annotation instanceof AbstractField) {
            return new AbstractFieldApplier(method, (AbstractField)annotation);
        }
        if (annotation instanceof AbstractSelect) {
            return new AbstractSelectApplier(method, (AbstractSelect)annotation);
        }
        if (annotation instanceof CheckBox) {
            return new CheckBoxApplier(method, (CheckBox)annotation);
        }
        if (annotation instanceof ComboBox) {
            return new ComboBoxApplier(method, (ComboBox)annotation);
        }
        if (annotation instanceof EnumComboBox) {
            return new EnumComboBoxApplier(method, (EnumComboBox)annotation);
        }
        if (annotation instanceof ListSelect) {
            return new ListSelectApplier(method, (ListSelect)annotation);
        }
        if (annotation instanceof DateField) {
            return new DateFieldApplier(method, (DateField)annotation);
        }
        if (annotation instanceof AbstractTextField) {
            return new AbstractTextFieldApplier(method, (AbstractTextField)annotation);
        }
        if (annotation instanceof TextField) {
            return new TextFieldApplier(method, (TextField)annotation);
        }
        if (annotation instanceof TextArea) {
            return new TextAreaApplier(method, (TextArea)annotation);
        }
        if (annotation instanceof PasswordField) {
            return new PasswordFieldApplier(method, (PasswordField)annotation);
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface AbstractField {
        public Class<? extends com.vaadin.ui.AbstractField> type() default com.vaadin.ui.AbstractField.class;

        public String[] styleNames() default {};

        public String width() default "";

        public String height() default "";

        public String caption() default "";

        public String description() default "";

        public boolean enabled() default true;

        public boolean immediate() default false;

        public boolean readOnly() default false;

        public Class<? extends Converter> converter() default Converter.class;

        public Class<? extends Validator>[] validators() default {};

        public boolean buffered() default false;

        public boolean invalidAllowed() default true;

        public boolean invalidCommitted() default false;

        public String conversionError() default "Could not convert value to {0}";

        public String requiredError() default "";

        public boolean validationVisible() default true;

        public boolean required() default false;

        public int tabIndex() default 0;
    }

    private static class AbstractFieldApplier
    extends AnnotationApplier<AbstractField, com.vaadin.ui.AbstractField<?>> {
        AbstractFieldApplier(Method method, AbstractField annotation) {
            super(method, annotation, com.vaadin.ui.AbstractField.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.AbstractField<?>> getActualFieldType() {
            return ((AbstractField)this.annotation).type() != com.vaadin.ui.AbstractField.class ? ((AbstractField)this.annotation).type() : null;
        }

        @Override
        public void applyTo(com.vaadin.ui.AbstractField<?> field) {
            if (((AbstractField)this.annotation).width().length() > 0) {
                field.setWidth(((AbstractField)this.annotation).width());
            }
            if (((AbstractField)this.annotation).height().length() > 0) {
                field.setHeight(((AbstractField)this.annotation).height());
            }
            if (((AbstractField)this.annotation).caption().length() > 0) {
                field.setCaption(((AbstractField)this.annotation).caption());
            }
            if (((AbstractField)this.annotation).description().length() > 0) {
                field.setDescription(((AbstractField)this.annotation).description());
            }
            field.setEnabled(((AbstractField)this.annotation).enabled());
            field.setImmediate(((AbstractField)this.annotation).immediate());
            field.setReadOnly(((AbstractField)this.annotation).readOnly());
            field.setBuffered(((AbstractField)this.annotation).buffered());
            field.setInvalidAllowed(((AbstractField)this.annotation).invalidAllowed());
            field.setInvalidCommitted(((AbstractField)this.annotation).invalidCommitted());
            field.setValidationVisible(((AbstractField)this.annotation).validationVisible());
            field.setRequired(((AbstractField)this.annotation).required());
            field.setTabIndex(((AbstractField)this.annotation).tabIndex());
            if (((AbstractField)this.annotation).converter() != Converter.class) {
                field.setConverter((Converter)FieldBuilder.instantiate(((AbstractField)this.annotation).converter()));
            }
            Object[] objectArray = ((AbstractField)this.annotation).validators();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Validator> validatorType = objectArray[n2];
                field.addValidator((Validator)FieldBuilder.instantiate(validatorType));
                ++n2;
            }
            objectArray = ((AbstractField)this.annotation).styleNames();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object styleName = objectArray[n2];
                field.addStyleName((String)styleName);
                ++n2;
            }
            if (((AbstractField)this.annotation).conversionError().length() > 0) {
                field.setConversionError(((AbstractField)this.annotation).conversionError());
            }
            if (((AbstractField)this.annotation).requiredError().length() > 0) {
                field.setRequiredError(((AbstractField)this.annotation).requiredError());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface AbstractSelect {
        public Class<? extends com.vaadin.ui.AbstractSelect> type() default com.vaadin.ui.AbstractSelect.class;

        public AbstractSelect.ItemCaptionMode itemCaptionMode() default AbstractSelect.ItemCaptionMode.EXPLICIT_DEFAULTS_ID;

        public String itemCaptionPropertyId() default "";

        public String itemIconPropertyId() default "";

        public String nullSelectionItemId() default "";

        public boolean multiSelect() default false;

        public boolean newItemsAllowed() default false;

        public boolean nullSelectionAllowed() default true;
    }

    private static class AbstractSelectApplier
    extends AnnotationApplier<AbstractSelect, com.vaadin.ui.AbstractSelect> {
        AbstractSelectApplier(Method method, AbstractSelect annotation) {
            super(method, annotation, com.vaadin.ui.AbstractSelect.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.AbstractSelect> getActualFieldType() {
            return ((AbstractSelect)this.annotation).type() != com.vaadin.ui.AbstractSelect.class ? ((AbstractSelect)this.annotation).type() : null;
        }

        @Override
        public void applyTo(com.vaadin.ui.AbstractSelect field) {
            field.setItemCaptionMode(((AbstractSelect)this.annotation).itemCaptionMode());
            if (((AbstractSelect)this.annotation).itemCaptionPropertyId().length() > 0) {
                field.setItemCaptionPropertyId((Object)((AbstractSelect)this.annotation).itemCaptionPropertyId());
            }
            if (((AbstractSelect)this.annotation).itemIconPropertyId().length() > 0) {
                field.setItemIconPropertyId((Object)((AbstractSelect)this.annotation).itemIconPropertyId());
            }
            if (((AbstractSelect)this.annotation).nullSelectionItemId().length() > 0) {
                field.setNullSelectionItemId((Object)((AbstractSelect)this.annotation).nullSelectionItemId());
            }
            field.setMultiSelect(((AbstractSelect)this.annotation).multiSelect());
            field.setNewItemsAllowed(((AbstractSelect)this.annotation).newItemsAllowed());
            field.setNullSelectionAllowed(((AbstractSelect)this.annotation).nullSelectionAllowed());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface AbstractTextField {
        public Class<? extends com.vaadin.ui.AbstractTextField> type() default com.vaadin.ui.TextField.class;

        public String nullRepresentation() default "null";

        public boolean nullSettingAllowed() default false;

        public AbstractTextField.TextChangeEventMode textChangeEventMode() default AbstractTextField.TextChangeEventMode.LAZY;

        public int textChangeTimeout() default -1;

        public int columns() default 0;

        public int maxLength() default -1;
    }

    private static class AbstractTextFieldApplier
    extends AnnotationApplier<AbstractTextField, com.vaadin.ui.AbstractTextField> {
        AbstractTextFieldApplier(Method method, AbstractTextField annotation) {
            super(method, annotation, com.vaadin.ui.AbstractTextField.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.AbstractTextField> getActualFieldType() {
            return ((AbstractTextField)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.AbstractTextField field) {
            field.setNullRepresentation(((AbstractTextField)this.annotation).nullRepresentation());
            field.setNullSettingAllowed(((AbstractTextField)this.annotation).nullSettingAllowed());
            field.setTextChangeEventMode(((AbstractTextField)this.annotation).textChangeEventMode());
            field.setTextChangeTimeout(((AbstractTextField)this.annotation).textChangeTimeout());
            field.setColumns(((AbstractTextField)this.annotation).columns());
            if (((AbstractTextField)this.annotation).maxLength() != -1) {
                field.setMaxLength(((AbstractTextField)this.annotation).maxLength());
            }
        }
    }

    protected static abstract class AnnotationApplier<A extends Annotation, F extends com.vaadin.ui.AbstractField<?>> {
        protected final Method method;
        protected final A annotation;
        protected final Class<F> fieldType;

        protected AnnotationApplier(Method method, A annotation, Class<F> fieldType) {
            if (method == null) {
                throw new IllegalArgumentException("null method");
            }
            if (annotation == null) {
                throw new IllegalArgumentException("null annotation");
            }
            if (fieldType == null) {
                throw new IllegalArgumentException("null fieldType");
            }
            this.method = method;
            this.annotation = annotation;
            this.fieldType = fieldType;
        }

        public final Method getMethod() {
            return this.method;
        }

        public final A getAnnotation() {
            return this.annotation;
        }

        public final Class<F> getFieldType() {
            return this.fieldType;
        }

        public abstract Class<? extends F> getActualFieldType();

        public abstract void applyTo(F var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface CheckBox {
        public Class<? extends com.vaadin.ui.CheckBox> type() default com.vaadin.ui.CheckBox.class;
    }

    private static class CheckBoxApplier
    extends AnnotationApplier<CheckBox, com.vaadin.ui.CheckBox> {
        CheckBoxApplier(Method method, CheckBox annotation) {
            super(method, annotation, com.vaadin.ui.CheckBox.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.CheckBox> getActualFieldType() {
            return ((CheckBox)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.CheckBox field) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ComboBox {
        public Class<? extends com.vaadin.ui.ComboBox> type() default com.vaadin.ui.ComboBox.class;

        public String inputPrompt() default "";

        public int pageLength() default -1;

        public boolean scrollToSelectedItem() default true;

        public boolean textInputAllowed() default true;

        public FilteringMode filteringMode() default FilteringMode.STARTSWITH;
    }

    private static class ComboBoxApplier
    extends AnnotationApplier<ComboBox, com.vaadin.ui.ComboBox> {
        ComboBoxApplier(Method method, ComboBox annotation) {
            super(method, annotation, com.vaadin.ui.ComboBox.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.ComboBox> getActualFieldType() {
            return ((ComboBox)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.ComboBox field) {
            if (((ComboBox)this.annotation).inputPrompt().length() > 0) {
                field.setInputPrompt(((ComboBox)this.annotation).inputPrompt());
            }
            if (((ComboBox)this.annotation).pageLength() != -1) {
                field.setPageLength(((ComboBox)this.annotation).pageLength());
            }
            field.setScrollToSelectedItem(((ComboBox)this.annotation).scrollToSelectedItem());
            field.setTextInputAllowed(((ComboBox)this.annotation).textInputAllowed());
            field.setFilteringMode(((ComboBox)this.annotation).filteringMode());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface DateField {
        public Class<? extends com.vaadin.ui.DateField> type() default com.vaadin.ui.DateField.class;

        public String dateFormat() default "";

        public String parseErrorMessage() default "";

        public String dateOutOfRangeMessage() default "";

        public Resolution resolution() default Resolution.DAY;

        public boolean showISOWeekNumbers() default false;

        public String timeZone() default "";

        public boolean lenient() default false;
    }

    private static class DateFieldApplier
    extends AnnotationApplier<DateField, com.vaadin.ui.DateField> {
        DateFieldApplier(Method method, DateField annotation) {
            super(method, annotation, com.vaadin.ui.DateField.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.DateField> getActualFieldType() {
            return ((DateField)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.DateField field) {
            if (((DateField)this.annotation).dateFormat().length() > 0) {
                field.setDateFormat(((DateField)this.annotation).dateFormat());
            }
            if (((DateField)this.annotation).parseErrorMessage().length() > 0) {
                field.setParseErrorMessage(((DateField)this.annotation).parseErrorMessage());
            }
            if (((DateField)this.annotation).dateOutOfRangeMessage().length() > 0) {
                field.setDateOutOfRangeMessage(((DateField)this.annotation).dateOutOfRangeMessage());
            }
            field.setResolution(((DateField)this.annotation).resolution());
            field.setShowISOWeekNumbers(((DateField)this.annotation).showISOWeekNumbers());
            if (((DateField)this.annotation).timeZone().length() > 0) {
                field.setTimeZone(TimeZone.getTimeZone(((DateField)this.annotation).timeZone()));
            }
            field.setLenient(((DateField)this.annotation).lenient());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface EnumComboBox {
        public Class<? extends org.dellroad.stuff.vaadin7.EnumComboBox> type() default org.dellroad.stuff.vaadin7.EnumComboBox.class;

        public Class<? extends Enum> enumClass() default Enum.class;
    }

    private static class EnumComboBoxApplier
    extends AnnotationApplier<EnumComboBox, org.dellroad.stuff.vaadin7.EnumComboBox> {
        EnumComboBoxApplier(Method method, EnumComboBox annotation) {
            super(method, annotation, org.dellroad.stuff.vaadin7.EnumComboBox.class);
        }

        @Override
        public Class<? extends org.dellroad.stuff.vaadin7.EnumComboBox> getActualFieldType() {
            return ((EnumComboBox)this.annotation).type();
        }

        @Override
        public void applyTo(org.dellroad.stuff.vaadin7.EnumComboBox field) {
            Class<? extends Enum> enumClass = ((EnumComboBox)this.annotation).enumClass();
            if (enumClass == Enum.class) {
                try {
                    enumClass = this.method.getReturnType().asSubclass(Enum.class);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("invalid @EnumComboBox annotation on non-Enum method " + this.getMethod());
                }
            }
            field.setEnumDataSource(enumClass);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ListSelect {
        public Class<? extends com.vaadin.ui.ListSelect> type() default com.vaadin.ui.ListSelect.class;

        public int rows() default -1;
    }

    private static class ListSelectApplier
    extends AnnotationApplier<ListSelect, com.vaadin.ui.ListSelect> {
        ListSelectApplier(Method method, ListSelect annotation) {
            super(method, annotation, com.vaadin.ui.ListSelect.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.ListSelect> getActualFieldType() {
            return ((ListSelect)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.ListSelect field) {
            if (((ListSelect)this.annotation).rows() != -1) {
                field.setRows(((ListSelect)this.annotation).rows());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface PasswordField {
        public Class<? extends com.vaadin.ui.PasswordField> type() default com.vaadin.ui.PasswordField.class;
    }

    private static class PasswordFieldApplier
    extends AnnotationApplier<PasswordField, com.vaadin.ui.PasswordField> {
        PasswordFieldApplier(Method method, PasswordField annotation) {
            super(method, annotation, com.vaadin.ui.PasswordField.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.PasswordField> getActualFieldType() {
            return ((PasswordField)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.PasswordField field) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ProvidesField {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface TextArea {
        public Class<? extends com.vaadin.ui.TextArea> type() default com.vaadin.ui.TextArea.class;

        public int rows() default -1;

        public boolean wordwrap() default true;
    }

    private static class TextAreaApplier
    extends AnnotationApplier<TextArea, com.vaadin.ui.TextArea> {
        TextAreaApplier(Method method, TextArea annotation) {
            super(method, annotation, com.vaadin.ui.TextArea.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.TextArea> getActualFieldType() {
            return ((TextArea)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.TextArea field) {
            field.setWordwrap(((TextArea)this.annotation).wordwrap());
            if (((TextArea)this.annotation).rows() != -1) {
                field.setMaxLength(((TextArea)this.annotation).rows());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface TextField {
        public Class<? extends com.vaadin.ui.TextField> type() default com.vaadin.ui.TextField.class;
    }

    private static class TextFieldApplier
    extends AnnotationApplier<TextField, com.vaadin.ui.TextField> {
        TextFieldApplier(Method method, TextField annotation) {
            super(method, annotation, com.vaadin.ui.TextField.class);
        }

        @Override
        public Class<? extends com.vaadin.ui.TextField> getActualFieldType() {
            return ((TextField)this.annotation).type();
        }

        @Override
        public void applyTo(com.vaadin.ui.TextField field) {
        }
    }
}

