/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.ProvidesProperty;
import org.dellroad.stuff.vaadin7.ProvidesPropertySort;
import org.dellroad.stuff.vaadin7.SortingPropertyExtractor;

public class ProvidesPropertyScanner<T> {
    private final ArrayList<PropertyDef<?>> propertyList = new ArrayList();
    private final SortingPropertyExtractor<T> propertyExtractor;

    public ProvidesPropertyScanner(Class<T> type) {
        String propertyName;
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        Set providesPropertyMethods = new MethodAnnotationScanner(type, ProvidesProperty.class).findAnnotatedMethods();
        Set providesPropertySortMethods = new MethodAnnotationScanner(type, ProvidesPropertySort.class).findAnnotatedMethods();
        HashMap<String, MethodAnnotationScanner.MethodInfo> providesPropertyNameMap = new HashMap<String, MethodAnnotationScanner.MethodInfo>();
        for (MethodAnnotationScanner.MethodInfo methodInfo : providesPropertyMethods) {
            String propertyName2 = this.getPropertyName(methodInfo);
            MethodAnnotationScanner.MethodInfo previousInfo = (MethodAnnotationScanner.MethodInfo)providesPropertyNameMap.get(propertyName2);
            if (previousInfo == null) {
                providesPropertyNameMap.put(propertyName2, methodInfo);
                continue;
            }
            switch (this.compareDeclaringClass(previousInfo.getMethod(), methodInfo.getMethod())) {
                case 0: {
                    throw new IllegalArgumentException("duplicate @" + ProvidesProperty.class.getSimpleName() + " declaration for property `" + propertyName2 + "' on method " + previousInfo.getMethod() + " and " + methodInfo.getMethod() + " declared in the same class");
                }
                case 1: {
                    providesPropertyNameMap.put(propertyName2, methodInfo);
                    break;
                }
            }
        }
        HashMap<String, MethodAnnotationScanner.MethodInfo> providesPropertySortNameMap = new HashMap<String, MethodAnnotationScanner.MethodInfo>();
        for (MethodAnnotationScanner.MethodInfo methodInfo : providesPropertySortMethods) {
            propertyName = this.getSortPropertyName(methodInfo);
            Class methodType = methodInfo.getMethod().getReturnType();
            if (methodType.isPrimitive()) {
                methodType = Primitive.get(methodType).getWrapperType();
            }
            if (!Comparable.class.isAssignableFrom(methodType) && !Comparator.class.isAssignableFrom(methodType)) {
                throw new IllegalArgumentException("invalid @" + ProvidesPropertySort.class.getSimpleName() + " declaration for property `" + propertyName + "': method " + methodInfo.getMethod() + " return type " + methodType.getName() + " implements neither " + Comparable.class.getName() + " nor " + Comparator.class.getName());
            }
            MethodAnnotationScanner.MethodInfo previousInfo = (MethodAnnotationScanner.MethodInfo)providesPropertySortNameMap.get(propertyName);
            if (previousInfo == null) {
                providesPropertySortNameMap.put(propertyName, methodInfo);
                continue;
            }
            switch (this.compareDeclaringClass(previousInfo.getMethod(), methodInfo.getMethod())) {
                case 0: {
                    throw new IllegalArgumentException("duplicate @" + ProvidesPropertySort.class.getSimpleName() + " declaration for property `" + propertyName + "' on method " + previousInfo.getMethod() + " and " + methodInfo.getMethod() + " declared in the same class");
                }
                case 1: {
                    providesPropertySortNameMap.put(propertyName, methodInfo);
                    break;
                }
            }
        }
        for (Map.Entry entry : providesPropertyNameMap.entrySet()) {
            propertyName = (String)entry.getKey();
            MethodAnnotationScanner.MethodInfo methodInfo = (MethodAnnotationScanner.MethodInfo)entry.getValue();
            Class propertyType = methodInfo.getMethod().getReturnType();
            Object defaultValue = null;
            if (propertyType.isPrimitive()) {
                Primitive primitiveType = Primitive.get(propertyType);
                defaultValue = primitiveType.getDefaultValue();
                propertyType = primitiveType.getWrapperType();
            }
            MethodAnnotationScanner.MethodInfo sortMethodInfo = (MethodAnnotationScanner.MethodInfo)providesPropertySortNameMap.get(propertyName);
            this.propertyList.add(this.createAnnotationPropertyDef(propertyName, propertyType, defaultValue, methodInfo, sortMethodInfo));
        }
        this.propertyExtractor = new SortingPropertyExtractor<T>(){

            @Override
            public <V> V getPropertyValue(T obj, PropertyDef<V> propertyDef) {
                if (!(propertyDef instanceof AnnotationPropertyDef)) {
                    throw new IllegalArgumentException("unknown property " + propertyDef);
                }
                AnnotationPropertyDef annotationPropertyDef = (AnnotationPropertyDef)propertyDef;
                return propertyDef.getType().cast(annotationPropertyDef.getMethodInfo().invoke(obj, new Object[0]));
            }

            @Override
            public boolean canSort(PropertyDef<?> propertyDef) {
                if (!(propertyDef instanceof AnnotationPropertyDef)) {
                    return false;
                }
                AnnotationPropertyDef annotationPropertyDef = (AnnotationPropertyDef)propertyDef;
                return annotationPropertyDef.getSortMethodInfo() != null;
            }

            @Override
            public int sort(PropertyDef<?> propertyDef, T obj1, T obj2) {
                if (!(propertyDef instanceof AnnotationPropertyDef)) {
                    throw new UnsupportedOperationException("unknown property " + propertyDef);
                }
                AnnotationPropertyDef annotationPropertyDef = (AnnotationPropertyDef)propertyDef;
                return annotationPropertyDef.getComparator().compare(obj1, obj2);
            }
        };
    }

    public List<PropertyDef<?>> getPropertyDefs() {
        return Collections.unmodifiableList(this.propertyList);
    }

    public SortingPropertyExtractor<T> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    private String getPropertyName(MethodAnnotationScanner.MethodInfo methodInfo) {
        return ((ProvidesProperty)methodInfo.getAnnotation()).value().length() > 0 ? ((ProvidesProperty)methodInfo.getAnnotation()).value() : methodInfo.getMethodPropertyName();
    }

    private String getSortPropertyName(MethodAnnotationScanner.MethodInfo methodInfo) {
        return ((ProvidesPropertySort)methodInfo.getAnnotation()).value().length() > 0 ? ((ProvidesPropertySort)methodInfo.getAnnotation()).value() : methodInfo.getMethodPropertyName();
    }

    private <V> AnnotationPropertyDef<V> createAnnotationPropertyDef(String propertyName, Class<V> propertyType, Object defaultValue, MethodAnnotationScanner.MethodInfo methodInfo, MethodAnnotationScanner.MethodInfo sortMethodInfo) {
        return new AnnotationPropertyDef<V>(propertyName, propertyType, propertyType.cast(defaultValue), methodInfo, sortMethodInfo);
    }

    private int compareDeclaringClass(Method method1, Method method2) {
        Class<?> class2;
        Class<?> class1 = method1.getDeclaringClass();
        if (class1 == (class2 = method2.getDeclaringClass())) {
            return 0;
        }
        if (class1.isAssignableFrom(class2)) {
            return 1;
        }
        if (class2.isAssignableFrom(class1)) {
            return -1;
        }
        throw new RuntimeException("internal error: incomparable classes " + class1.getName() + " and " + class2.getName());
    }

    private class AnnotationPropertyDef<V>
    extends PropertyDef<V> {
        private static final long serialVersionUID = 4983663265225248971L;
        private final MethodAnnotationScanner.MethodInfo methodInfo;
        private final MethodAnnotationScanner.MethodInfo sortMethodInfo;
        private Comparator<T> comparator;

        AnnotationPropertyDef(String name, Class<V> type, V defaultValue, MethodAnnotationScanner.MethodInfo methodInfo, MethodAnnotationScanner.MethodInfo sortMethodInfo) {
            super(name, type, defaultValue);
            this.methodInfo = methodInfo;
            this.sortMethodInfo = sortMethodInfo;
        }

        public MethodAnnotationScanner.MethodInfo getMethodInfo() {
            return this.methodInfo;
        }

        public MethodAnnotationScanner.MethodInfo getSortMethodInfo() {
            return this.sortMethodInfo;
        }

        public Comparator<T> getComparator() {
            if (this.sortMethodInfo == null) {
                throw new UnsupportedOperationException("can't sort property " + this);
            }
            if (this.comparator != null) {
                return this.comparator;
            }
            if (Comparator.class.isAssignableFrom(this.sortMethodInfo.getMethod().getReturnType())) {
                this.comparator = new Comparator<T>(){
                    private Comparator<T> comparator;

                    @Override
                    public int compare(T obj1, T obj2) {
                        if (this.comparator == null) {
                            this.comparator = (Comparator)AnnotationPropertyDef.this.sortMethodInfo.invoke(obj1, new Object[0]);
                        }
                        return this.comparator.compare(obj1, obj2);
                    }
                };
                return this.comparator;
            }
            this.comparator = new Comparator<T>(){

                @Override
                public int compare(T obj1, T obj2) {
                    Comparable value1 = (Comparable)AnnotationPropertyDef.this.sortMethodInfo.invoke(obj1, new Object[0]);
                    Comparable value2 = (Comparable)AnnotationPropertyDef.this.sortMethodInfo.invoke(obj2, new Object[0]);
                    if (value1 == null && value2 != null) {
                        return -1;
                    }
                    if (value1 != null && value2 == null) {
                        return 1;
                    }
                    if (value1 == null && value2 == null) {
                        return 0;
                    }
                    return value1.compareTo(value2);
                }
            };
            return this.comparator;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            AnnotationPropertyDef that = (AnnotationPropertyDef)obj;
            return Objects.equals(this.methodInfo, that.methodInfo) && Objects.equals(this.sortMethodInfo, that.sortMethodInfo);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.methodInfo != null ? this.methodInfo.hashCode() : 0) ^ (this.sortMethodInfo != null ? this.sortMethodInfo.hashCode() : 0);
        }
    }
}

