/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Property;
import java.util.EventObject;

public abstract class ReadOnlyProperty<V>
implements Property<V>,
Property.ValueChangeNotifier,
Property.ReadOnlyStatusChangeNotifier {
    private Object listeners;

    public void setValue(V value) {
        throw new Property.ReadOnlyException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setReadOnly(boolean readOnly) {
        if (!readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    protected void fireValueChange() {
        if (this.listeners == null) {
            return;
        }
        ValueChangeEvent event = new ValueChangeEvent();
        if (this.listeners instanceof Property.ValueChangeListener) {
            ((Property.ValueChangeListener)this.listeners).valueChange((Property.ValueChangeEvent)event);
        } else {
            Property.ValueChangeListener[] valueChangeListenerArray = (Property.ValueChangeListener[])this.listeners;
            int n = valueChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property.ValueChangeListener listener = valueChangeListenerArray[n2];
                listener.valueChange((Property.ValueChangeEvent)event);
                ++n2;
            }
        }
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (this.listeners == null) {
            this.listeners = listener;
            this.firstListenerAdded();
        } else if (this.listeners instanceof Property.ValueChangeListener) {
            this.listeners = new Property.ValueChangeListener[]{(Property.ValueChangeListener)this.listeners, listener};
        } else {
            Property.ValueChangeListener[] oldArray = (Property.ValueChangeListener[])this.listeners;
            Property.ValueChangeListener[] newArray = new Property.ValueChangeListener[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = listener;
            this.listeners = newArray;
        }
    }

    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        if (this.listeners instanceof Property.ValueChangeListener) {
            if (!this.listeners.equals(listener)) {
                return;
            }
            this.listeners = null;
            this.lastListenerRemoved();
            return;
        }
        Property.ValueChangeListener[] oldArray = (Property.ValueChangeListener[])this.listeners;
        int index = -1;
        int i = 0;
        while (i < oldArray.length) {
            if (oldArray[i].equals(listener)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        switch (oldArray.length) {
            case 0: 
            case 1: {
                throw new RuntimeException("internal error");
            }
            case 2: {
                this.listeners = oldArray[1 - index];
                break;
            }
            default: {
                Property.ValueChangeListener[] newArray = new Property.ValueChangeListener[oldArray.length - 1];
                System.arraycopy(oldArray, 0, newArray, 0, index);
                System.arraycopy(oldArray, index + 1, newArray, index, oldArray.length - index - 1);
                this.listeners = newArray;
            }
        }
    }

    public void addListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
    }

    public void removeListener(Property.ValueChangeListener listener) {
        this.removeValueChangeListener(listener);
    }

    public void addReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
    }

    public void removeReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
    }

    public void addListener(Property.ReadOnlyStatusChangeListener listener) {
        this.addReadOnlyStatusChangeListener(listener);
    }

    public void removeListener(Property.ReadOnlyStatusChangeListener listener) {
        this.removeReadOnlyStatusChangeListener(listener);
    }

    private class ValueChangeEvent
    extends EventObject
    implements Property.ValueChangeEvent {
        ValueChangeEvent() {
            super(ReadOnlyProperty.this);
        }

        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

