/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.VaadinPortletRequest;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedHttpSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringVaadinSessionListener
implements SessionInitListener,
SessionDestroyListener {
    private static final long serialVersionUID = -2107311484324869198L;
    private static final WeakHashMap<VaadinSession, ConfigurableWebApplicationContext> CONTEXT_MAP = new WeakHashMap();
    private transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final UUID uuid = UUID.randomUUID();
    private final String applicationName;
    private final String configLocation;

    public SpringVaadinSessionListener(String applicationName, String configLocation) {
        if (applicationName == null) {
            throw new IllegalArgumentException("null applicationName");
        }
        this.applicationName = applicationName;
        this.configLocation = configLocation;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public static ConfigurableWebApplicationContext getApplicationContext(VaadinSession session) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        return CONTEXT_MAP.get(session);
    }

    public static ConfigurableWebApplicationContext getApplicationContext() {
        VaadinSession session = VaadinUtil.getCurrentSession();
        ConfigurableWebApplicationContext context = SpringVaadinSessionListener.getApplicationContext(session);
        if (context == null) {
            throw new IllegalStateException("there is no Spring application context associated with the current VaadinSession; are you using SpringVaadinServlet instead of VaadinServlet?");
        }
        return context;
    }

    public static void configureBean(Object bean) {
        BeanConfigurerSupport beanConfigurerSupport = new BeanConfigurerSupport();
        beanConfigurerSupport.setBeanFactory((BeanFactory)SpringVaadinSessionListener.getApplicationContext().getBeanFactory());
        beanConfigurerSupport.afterPropertiesSet();
        beanConfigurerSupport.configureBean(bean);
        beanConfigurerSupport.destroy();
    }

    public void sessionInit(final SessionInitEvent event) throws ServiceException {
        VaadinUtil.invoke(event.getSession(), new Runnable(){

            @Override
            public void run() {
                SpringVaadinSessionListener.this.loadContext(event.getSession(), event.getRequest());
            }
        });
    }

    protected void loadContext(VaadinSession session, VaadinRequest request) {
        if (session == null) {
            throw new IllegalStateException("null session");
        }
        VaadinUtil.assertSession(session);
        if (request == null) {
            throw new IllegalStateException("null request");
        }
        if (SpringVaadinSessionListener.getApplicationContext(session) != null) {
            throw new IllegalStateException("context already loaded for session " + session);
        }
        this.log.info("creating new application context for Vaadin application [" + this.getApplicationName() + "] in session " + session);
        String contextPath = "/";
        ServletContext servletContext = null;
        WebApplicationContext parent = null;
        if (request instanceof VaadinServletRequest) {
            contextPath = String.valueOf(((VaadinServletRequest)request).getHttpServletRequest().getContextPath()) + "/";
            servletContext = ((WrappedHttpSession)session.getSession()).getHttpSession().getServletContext();
            parent = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        } else if (request instanceof VaadinPortletRequest) {
            this.log.warn("portlets are not supported yet");
        } else {
            this.log.warn("unsupported VaadinRequest instance: " + request);
        }
        XmlWebApplicationContext context = new XmlWebApplicationContext();
        context.setId(String.valueOf(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX) + contextPath + this.getApplicationName() + "-" + this.uuid);
        if (parent != null) {
            context.setParent((ApplicationContext)parent);
        }
        if (servletContext != null) {
            context.setServletContext(servletContext);
        }
        context.setNamespace(this.getApplicationName());
        if (this.configLocation != null) {
            context.setConfigLocation(this.configLocation);
        }
        boolean success = false;
        CONTEXT_MAP.put(session, (ConfigurableWebApplicationContext)context);
        try {
            context.refresh();
            success = true;
        }
        finally {
            if (!success) {
                CONTEXT_MAP.remove(session);
            }
        }
    }

    public void sessionDestroy(SessionDestroyEvent event) {
        VaadinSession session = event.getSession();
        final ConfigurableWebApplicationContext context = SpringVaadinSessionListener.getApplicationContext(session);
        if (context == null) {
            this.log.info(String.valueOf(this.getClass().getSimpleName()) + ".sessionDestroy() invoked but no application context found" + " for Vaadin application [" + this.getApplicationName() + "]");
            return;
        }
        CONTEXT_MAP.remove(session);
        VaadinUtil.invoke(session, new Runnable(){

            @Override
            public void run() {
                SpringVaadinSessionListener.this.log.info("closing Vaadin application [" + SpringVaadinSessionListener.this.getApplicationName() + "] application context: " + context);
                context.close();
            }
        });
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.log = LoggerFactory.getLogger(this.getClass());
        final VaadinSession session = VaadinUtil.getCurrentSession();
        final VaadinRequest request = VaadinUtil.getCurrentRequest();
        VaadinUtil.invoke(session, new Runnable(){

            @Override
            public void run() {
                SpringVaadinSessionListener.this.loadContext(session, request);
            }
        });
    }
}

