/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.leveldb;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.leveldb.LevelDBKVStore;
import org.jsimpledb.kv.leveldb.LevelDBUtil;
import org.jsimpledb.kv.leveldb.SnapshotLevelDBKVStore;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LevelDBAtomicKVStore
extends ForwardingKVStore
implements AtomicKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean();
    private final DBFactory factory;
    @GuardedBy(value="this")
    private Options options = new Options().createIfMissing(true).logger(new org.iq80.leveldb.Logger(){

        public void log(String message) {
            LevelDBAtomicKVStore.this.log.info("[LevelDB] " + message);
        }
    });
    @GuardedBy(value="this")
    private File directory;
    @GuardedBy(value="this")
    private LevelDBKVStore kv;
    @GuardedBy(value="this")
    private DB db;

    public LevelDBAtomicKVStore() {
        this(LevelDBUtil.getDefaultDBFactory());
    }

    public LevelDBAtomicKVStore(DBFactory factory) {
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"null factory");
        this.factory = factory;
    }

    public synchronized File getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(File directory) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.directory = directory;
    }

    public synchronized DB getDB() {
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"not started");
        return this.db;
    }

    public synchronized Options getOptions() {
        return this.options;
    }

    public synchronized void setOptions(Options options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"null options");
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = options;
    }

    public synchronized void setBlockRestartInterval(int blockRestartInterval) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.blockRestartInterval(blockRestartInterval);
    }

    public synchronized void setBlockSize(int blockSize) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.blockSize(blockSize);
    }

    public synchronized void setCacheSize(long cacheSize) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.cacheSize(cacheSize);
    }

    public synchronized void setCompressionType(CompressionType compressionType) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.compressionType(compressionType);
    }

    public synchronized void setCreateIfMissing(boolean createIfMissing) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.createIfMissing(createIfMissing);
    }

    public synchronized void setErrorIfExists(boolean errorIfExists) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.errorIfExists(errorIfExists);
    }

    public synchronized void setMaxOpenFiles(int maxOpenFiles) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.maxOpenFiles(maxOpenFiles);
    }

    public synchronized void setParanoidChecks(boolean paranoidChecks) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.paranoidChecks(paranoidChecks);
    }

    public synchronized void setVerifyChecksums(boolean verifyChecksums) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.verifyChecksums(verifyChecksums);
    }

    public synchronized void setWriteBufferSize(int writeBufferSize) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = this.options.writeBufferSize(writeBufferSize);
    }

    @PostConstruct
    public synchronized void start() {
        if (this.db != null) {
            return;
        }
        this.log.info("starting " + (Object)((Object)this));
        Preconditions.checkState((this.directory != null ? 1 : 0) != 0, (Object)"no directory configured");
        if (!this.directory.exists()) {
            if (!this.options.createIfMissing()) {
                throw new RuntimeException("directory `" + this.directory + "' does not exist");
            }
            if (!this.directory.mkdirs()) {
                throw new RuntimeException("failed to create directory `" + this.directory + "'");
            }
        }
        if (!this.directory.isDirectory()) {
            throw new RuntimeException("file `" + this.directory + "' is not a directory");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("opening " + (Object)((Object)this) + " LevelDB database");
        }
        try {
            this.db = this.factory.open(this.directory, this.options);
        }
        catch (IOException e) {
            throw new RuntimeException("LevelDB database startup failed", e);
        }
        this.kv = new LevelDBKVStore(this.db, new ReadOptions().verifyChecksums(this.options.verifyChecksums()), null);
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LevelDBAtomicKVStore.this.stop();
                }
            });
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.db == null) {
            return;
        }
        this.log.info("stopping " + (Object)((Object)this));
        this.kv.close();
        this.kv = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.info("closing " + (Object)((Object)this) + " LevelDB database");
            }
            this.db.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing database during shutdown (ignoring)", e);
        }
        this.db = null;
    }

    protected synchronized LevelDBKVStore delegate() {
        Preconditions.checkState((this.db != null && this.kv != null ? 1 : 0) != 0, (Object)"closed");
        return this.kv;
    }

    public synchronized SnapshotLevelDBKVStore snapshot() {
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"closed");
        return new SnapshotLevelDBKVStore(this.db, this.options.verifyChecksums());
    }

    public synchronized void mutate(Mutations mutations, boolean sync) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"closed");
        try (WriteBatch batch = this.db.createWriteBatch();){
            ReadOptions iteratorOptions = new ReadOptions().verifyChecksums(this.options.verifyChecksums()).fillCache(false);
            for (KeyRange range : mutations.getRemoveRanges()) {
                byte[] min = range.getMin();
                byte[] max = range.getMax();
                if (min != null && max != null && ByteUtil.isConsecutive((byte[])min, (byte[])max)) {
                    batch.delete(min);
                    continue;
                }
                LevelDBKVStore.Iterator i = this.kv.createIterator(iteratorOptions, min, max, false);
                Throwable throwable = null;
                try {
                    while (i.hasNext()) {
                        batch.delete(i.next().getKey());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (i == null) continue;
                    if (throwable != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    i.close();
                }
            }
            for (Map.Entry entry : mutations.getPutPairs()) {
                batch.put((byte[])entry.getKey(), (byte[])entry.getValue());
            }
            for (Map.Entry adjust : mutations.getAdjustPairs()) {
                long oldValue;
                byte[] key = (byte[])adjust.getKey();
                long diff = (Long)adjust.getValue();
                byte[] oldBytes = this.kv.get(key);
                if (oldBytes == null) {
                    oldBytes = new byte[8];
                }
                try {
                    oldValue = this.kv.decodeCounter(oldBytes);
                }
                catch (IllegalArgumentException e) {
                    if (batch != null) {
                        if (var4_5 != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            batch.close();
                        }
                    }
                    return;
                }
                batch.put(key, this.kv.encodeCounter(oldValue + diff));
            }
            this.db.write(batch, new WriteOptions().sync(sync));
        }
        catch (IOException e) {
            throw new DBException("error applying changes to LevelDB", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.db != null) {
                this.log.warn((Object)((Object)this) + " leaked without invoking stop()");
            }
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[dir=" + this.directory + ",kv=" + (Object)((Object)this.kv) + "]";
    }
}

