/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.leveldb;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.CloseableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBKVStore
extends AbstractKVStore
implements CloseableKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final CloseableTracker cursorTracker = new CloseableTracker();
    private final ReadOptions readOptions;
    private final WriteBatch writeBatch;
    private final DB db;
    private volatile boolean closed;

    public LevelDBKVStore(DB db) {
        this(db, null, null);
    }

    public LevelDBKVStore(DB db, ReadOptions readOptions, WriteBatch writeBatch) {
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"null db");
        this.db = db;
        this.readOptions = readOptions != null ? readOptions : new ReadOptions();
        this.writeBatch = writeBatch;
        if (this.log.isTraceEnabled()) {
            this.log.trace("created " + (Object)((Object)this));
        }
    }

    public DB getDB() {
        return this.db;
    }

    public byte[] get(byte[] key) {
        key.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        return this.db.get(key, this.readOptions);
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        return this.createIterator(this.readOptions, minKey, maxKey, reverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] key, byte[] value) {
        key.getClass();
        value.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        if (this.writeBatch != null) {
            WriteBatch writeBatch = this.writeBatch;
            synchronized (writeBatch) {
                this.writeBatch.put(key, value);
            }
        } else {
            this.db.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) {
        key.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        if (this.writeBatch != null) {
            WriteBatch writeBatch = this.writeBatch;
            synchronized (writeBatch) {
                this.writeBatch.delete(key);
            }
        } else {
            this.db.delete(key);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.log.warn((Object)((Object)this) + " leaked without invoking close()");
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[db=" + this.db + ",options=" + this.readOptions + (this.writeBatch != null ? ",writeBatch=" + this.writeBatch : "") + "]";
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("closing " + (Object)((Object)this));
        }
        this.cursorTracker.close();
    }

    Iterator createIterator(ReadOptions readOptions, byte[] minKey, byte[] maxKey, boolean reverse) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        return new Iterator(this.db.iterator(readOptions), minKey, maxKey, reverse);
    }

    final class Iterator
    implements CloseableIterator<KVPair> {
        private final DBIterator cursor;
        private final byte[] minKey;
        private final byte[] maxKey;
        private final boolean reverse;
        private KVPair next;
        private byte[] removeKey;
        private boolean finished;
        private boolean closed;

        private Iterator(DBIterator cursor, byte[] minKey, byte[] maxKey, boolean reverse) {
            LevelDBKVStore.this.cursorTracker.add((Object)this, (Closeable)cursor);
            Preconditions.checkArgument((minKey == null || maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
            this.cursor = cursor;
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.reverse = reverse;
            if (LevelDBKVStore.this.log.isTraceEnabled()) {
                LevelDBKVStore.this.log.trace("created " + this);
            }
            if (reverse) {
                if (maxKey != null) {
                    if (LevelDBKVStore.this.log.isTraceEnabled()) {
                        LevelDBKVStore.this.log.trace("seek to " + ByteUtil.toString((byte[])maxKey));
                    }
                    this.cursor.seek(maxKey);
                } else {
                    if (LevelDBKVStore.this.log.isTraceEnabled()) {
                        LevelDBKVStore.this.log.trace("seek to last");
                    }
                    this.cursor.seekToLast();
                }
            } else if (minKey != null) {
                if (LevelDBKVStore.this.log.isTraceEnabled()) {
                    LevelDBKVStore.this.log.trace("seek to " + ByteUtil.toString((byte[])minKey));
                }
                this.cursor.seek(minKey);
            }
        }

        public synchronized boolean hasNext() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            return this.next != null || this.findNext();
        }

        public synchronized KVPair next() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            if (this.next == null && !this.findNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != null);
            KVPair pair = this.next;
            this.removeKey = pair.getKey();
            this.next = null;
            return pair;
        }

        public synchronized void remove() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            Preconditions.checkState((this.removeKey != null ? 1 : 0) != 0);
            if (LevelDBKVStore.this.log.isTraceEnabled()) {
                LevelDBKVStore.this.log.trace("remove " + ByteUtil.toString((byte[])this.removeKey));
            }
            LevelDBKVStore.this.remove(this.removeKey);
            this.removeKey = null;
        }

        private boolean findNext() {
            assert (this.next == null);
            if (this.finished) {
                return false;
            }
            try {
                this.next = new KVPair(this.reverse ? this.cursor.prev() : (Map.Entry)this.cursor.next());
                if (LevelDBKVStore.this.log.isTraceEnabled()) {
                    LevelDBKVStore.this.log.trace("seek " + (this.reverse ? "previous" : "next") + " -> " + this.next);
                }
            }
            catch (NoSuchElementException e) {
                if (LevelDBKVStore.this.log.isTraceEnabled()) {
                    LevelDBKVStore.this.log.trace("seek " + (this.reverse ? "previous" : "next") + " -> NO MORE");
                }
                this.finished = true;
                return false;
            }
            if (this.reverse ? this.minKey != null && ByteUtil.compare((byte[])this.next.getKey(), (byte[])this.minKey) < 0 : this.maxKey != null && ByteUtil.compare((byte[])this.next.getKey(), (byte[])this.maxKey) >= 0) {
                if (LevelDBKVStore.this.log.isTraceEnabled()) {
                    LevelDBKVStore.this.log.trace("stopping at bound " + ByteUtil.toString((byte[])(this.reverse ? this.minKey : this.maxKey)));
                }
                this.next = null;
                this.finished = true;
                return false;
            }
            return true;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (LevelDBKVStore.this.log.isTraceEnabled()) {
                LevelDBKVStore.this.log.trace("closing " + this);
            }
            try {
                this.cursor.close();
            }
            catch (Throwable e) {
                LevelDBKVStore.this.log.debug("caught exception closing db iterator (ignoring)", e);
            }
        }

        public String toString() {
            return LevelDBKVStore.class.getSimpleName() + "." + this.getClass().getSimpleName() + "[minKey=" + ByteUtil.toString((byte[])this.minKey) + ",maxKey=" + ByteUtil.toString((byte[])this.maxKey) + (this.reverse ? ",reverse" : "") + "]";
        }
    }
}

