/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.tuple;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import org.jsimpledb.tuple.Tuple;

public final class Tuples {
    private Tuples() {
    }

    public static Tuple createTuple(Iterable<?> values) {
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"null values");
        return Tuples.createTuple(Lists.newArrayList(values).toArray());
    }

    public static Tuple createTuple(Object ... values) {
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"null values");
        Class<? extends Tuple> tupleClass = Tuples.tupleClassForSize(values.length);
        Object[] parameterTypes = new Class[values.length];
        Arrays.fill(parameterTypes, Object.class);
        try {
            return tupleClass.getConstructor((Class<?>[])parameterTypes).newInstance(values);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("can't instantiate " + tupleClass, e);
        }
    }

    public static Class<? extends Tuple> tupleClassForSize(int size) {
        Preconditions.checkArgument((size >= 1 ? 1 : 0) != 0, (Object)"invalid non-positive size");
        String name = Tuple.class.getName() + size;
        try {
            return Class.forName(name, false, Tuple.class.getClassLoader()).asSubclass(Tuple.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("can't find class `" + name + "' of size " + size, e);
        }
    }

    public static int tupleSizeOf(Class<? extends Tuple> tupleClass) {
        int size = 1;
        while (true) {
            try {
                if (Tuples.tupleClassForSize(size).isAssignableFrom(tupleClass)) {
                    return size;
                }
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalArgumentException("not a tuple (sub)class: " + tupleClass);
            }
            ++size;
        }
    }
}

